import HeaderNav from "@/components/HeaderNav";
import Footer from "@/components/Footer";
import GlobalSlider from "@/components/GlobalSlider";
import SearchBar from "@/components/SearchBar";
import FeatureTiles from "@/components/FeatureTiles";
import { homeSlides } from "@/data/homeSlides";

function Home() {
  return (
    <div className="min-h-screen bg-background">
      {/* Header Navigation */}
      <HeaderNav />
      
      {/* Hero Slider Section */}
      <section data-testid="section-hero-slider">
        <GlobalSlider 
          slides={homeSlides.filter(slide => slide.enabled !== false)} 
          autoPlay={true} 
          interval={10000} 
        />
      </section>
      {/* Search Bar Section */}
      <section className="bg-gray-50 dark:bg-gray-900" data-testid="section-search-bar">
        <SearchBar />
      </section>
      
      {/* Feature Tiles Section */}
      <section className="bg-white dark:bg-gray-800" data-testid="section-feature-tiles">
        <FeatureTiles />
      </section>
      
      {/* Additional Value Proposition Section */}
      <section className="bg-gradient-to-br from-primary/5 to-accent/5 py-16" data-testid="section-value-proposition">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
          <h2 className="text-3xl md:text-4xl font-bold text-gray-900 dark:text-white mb-6">
            Why Choose IBrandBiz?
          </h2>
          <div className="grid grid-cols-1 md:grid-cols-3 gap-8">
            <div className="flex flex-col items-center" data-testid="value-prop-ai-powered">
              <div className="w-16 h-16 bg-white border-2 border-accent rounded-full flex items-center justify-center mb-4">
                <span className="text-2xl">🤖</span>
              </div>
              <h3 className="text-xl font-semibold mb-2">AI-Powered</h3>
              <p className="text-muted-foreground">
                Advanced AI algorithms create unique, memorable names and designs tailored to your business.
              </p>
            </div>
            <div className="flex flex-col items-center" data-testid="value-prop-instant-results">
              <div className="w-16 h-16 bg-white border-2 border-primary rounded-full flex items-center justify-center mb-4">
                <span className="text-2xl">⚡</span>
              </div>
              <h3 className="text-xl font-semibold mb-2">Instant Results</h3>
              <p className="text-muted-foreground">
                Get professional-quality brand assets in minutes, not weeks. No waiting, no delays.
              </p>
            </div>
            <div className="flex flex-col items-center" data-testid="value-prop-all-in-one">
              <div className="w-16 h-16 bg-white border-2 border-accent rounded-full flex items-center justify-center mb-4">
                <span className="text-2xl">🎯</span>
              </div>
              <h3 className="text-xl font-semibold mb-2">All-in-One</h3>
              <p className="text-muted-foreground">
                Everything you need in one place: names, logos, domains, and brand assets.
              </p>
            </div>
          </div>
        </div>
      </section>
      
      {/* Stats Section */}
      <section className="bg-white dark:bg-gray-800 py-16" data-testid="section-stats">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="grid grid-cols-2 md:grid-cols-4 gap-8 text-center">
            <div data-testid="stat-projects-designed">
              <div className="text-3xl md:text-4xl font-bold text-green-500 mb-2">3.5K+</div>
              <div className="text-muted-foreground">Projects Designed</div>
            </div>
            <div data-testid="stat-business-names">
              <div className="text-3xl md:text-4xl font-bold text-green-500 mb-2">200+</div>
              <div className="text-muted-foreground">Business Names Generated</div>
            </div>
            <div data-testid="stat-clients-supported">
              <div className="text-3xl md:text-4xl font-bold text-green-500 mb-2">2K+</div>
              <div className="text-muted-foreground">Clients Supported</div>
            </div>
            <div data-testid="stat-years-experience">
              <div className="text-3xl md:text-4xl font-bold text-green-500 mb-2">25+</div>
              <div className="text-muted-foreground">Years Creative Experience</div>
            </div>
          </div>
        </div>
      </section>
      
      {/* Footer */}
      <Footer />
    </div>
  );
}

export default Home;