import TemplatePage from "@/components/TemplatePage";
import { Briefcase, Gavel, FileText, DollarSign, BookOpen, ShieldCheck, Building2, Search, Clock, CreditCard, RotateCcw, Shield, Gift, HelpCircle, Lightbulb, Globe, Zap, Palette, FileBarChart, Star, Crown, Presentation, Edit, Monitor, Smartphone } from "lucide-react";
import Accordion, { QA } from "@/components/ui/Accordion";
import { faqsImage } from "@/assets";

export default function FAQPage() {
  const systemUsageFaqs: QA[] = [
    {
      q: "Brand Name Wizard",
      icon: <Lightbulb className="w-5 h-5 text-black dark:text-white" />,
      a: (
        <>
          <p className="mb-2">Enter a few keywords that describe your business.</p>
          <p className="mb-2">Our AI will generate unique, memorable business name options.</p>
          <p>Save your favorite names directly into your dashboard for later use.</p>
        </>
      ),
    },
    {
      q: "Domains",
      icon: <Globe className="w-5 h-5 text-black dark:text-white" />,
      a: (
        <>
          <p className="mb-2">Search available domain names that match your chosen business name.</p>
          <p className="mb-2">Instantly check availability and lock in your brand's online presence.</p>
          <p>This tool helps you ensure your business name and website stay consistent.</p>
        </>
      ),
    },
    {
      q: "Slogan Generator",
      icon: <Zap className="w-5 h-5 text-black dark:text-white" />,
      a: (
        <>
          <p className="mb-2">Enter your business name and a short description of what you do.</p>
          <p className="mb-2">The AI will suggest catchy slogans and taglines.</p>
          <p>Pick the one that matches your vibe — or generate more until you find the perfect fit.</p>
        </>
      ),
    },
    {
      q: "Brand Kit",
      icon: <Palette className="w-5 h-5 text-black dark:text-white" />,
      a: (
        <>
          <p className="mb-2">Start with your business name and slogan.</p>
          <p className="mb-2">The generator will create a full identity kit: logos, color palettes, and fonts.</p>
          <p>Download and use your brand kit across websites, social media, and print.</p>
        </>
      ),
    },
    {
      q: "AI Frameworks Builder",
      icon: <FileBarChart className="w-5 h-5 text-black dark:text-white" />,
      a: (
        <>
          <p className="mb-2">Answer guided questions about your business (what you offer, target market, goals).</p>
          <p className="mb-2">Our AI creates a professional business plan tailored to your inputs.</p>
          <p className="mb-2">Export to PDF, DOCX, or Google Docs for investors, banks, or personal use.</p>
          <p className="mt-4 font-medium">👉 Tip: You can access everything from your Dashboard, save projects as you go, and return anytime to edit or expand them.</p>
        </>
      ),
    },
  ];

  const presentationTemplatesFaqs: QA[] = [
    {
      q: "What sizes are available?",
      icon: <Monitor className="w-5 h-5 text-black dark:text-white" />,
      a: (
        <>
          <p className="mb-2">We provide two sizes for your branded PowerPoint templates:</p>
          <ul className="space-y-1 mb-2 ml-4">
            <li>• <strong>16:9 Widescreen</strong> (default for modern presentations)</li>
            <li>• <strong>4:3 Standard</strong> (for compatibility with legacy displays)</li>
          </ul>
          <p>Both sizes contain the same set of pages so you don't lose functionality.</p>
        </>
      ),
    },
    {
      q: "What's included in my template?",
      icon: <Presentation className="w-5 h-5 text-black dark:text-white" />,
      a: (
        <>
          <p className="mb-2">Your template includes:</p>
          <ul className="space-y-1 ml-4">
            <li>• <strong>Cover slide</strong> — pulled from your chosen Cover Template and applied to the master</li>
            <li>• <strong>Branding side panel</strong> — shows your logo, brand fonts, and 6 chosen accent colors</li>
            <li>• <strong>Section dividers</strong> — predesigned slides for breaking content into sections</li>
            <li>• <strong>Body layouts</strong> — a gallery of professional slide types (title, content, charts, bullets)</li>
            <li>• <strong>Infographic pages</strong> — preset diagrams with 2, 3, 4, or 6 sections in a variety of styles</li>
            <li>• <strong>Charts & tables</strong> — live PowerPoint elements that update with your brand colors</li>
          </ul>
        </>
      ),
    },
    {
      q: "How does branding work?",
      icon: <Palette className="w-5 h-5 text-black dark:text-white" />,
      a: (
        <>
          <ul className="space-y-2">
            <li><strong>Logo Upload:</strong> Add your brand logo (regular + reverse/white version auto-generated)</li>
            <li><strong>Colors:</strong> Pick up to 6 accent colors. Text defaults remain white or black for readability</li>
            <li><strong>Fonts:</strong> Choose your heading and body fonts (we embed them directly into PPTX so your presentation always displays correctly)</li>
          </ul>
        </>
      ),
    },
    {
      q: "Can I use my Infographics separately?",
      icon: <FileBarChart className="w-5 h-5 text-black dark:text-white" />,
      a: (
        <>
          <p className="mb-2">Yes. Infographics can be:</p>
          <ul className="space-y-1 ml-4">
            <li>• Sent directly from the Infographics section into your saved template</li>
            <li>• Or chosen while building your PPT template</li>
          </ul>
          <p className="mt-2">They automatically adapt to your brand colors and can be duplicated/edited in PowerPoint.</p>
        </>
      ),
    },
    {
      q: "Can I edit the slides?",
      icon: <Edit className="w-5 h-5 text-black dark:text-white" />,
      a: (
        <>
          <p className="mb-2">Yes! Once generated, your slides behave like any normal PowerPoint template:</p>
          <ul className="space-y-1 ml-4">
            <li>• Replace text, swap images, move shapes</li>
            <li>• Duplicate infographic pages as needed</li>
            <li>• Charts are live and can be updated with your own data</li>
          </ul>
        </>
      ),
    },
    {
      q: "What if I need both sizes?",
      icon: <Smartphone className="w-5 h-5 text-black dark:text-white" />,
      a: (
        <>
          <p>You can generate both 16:9 and 4:3 templates with the same brand settings. Each size keeps the same structure, so you're always presentation-ready.</p>
        </>
      ),
    },
  ];

  const subscriptionFaqs: QA[] = [
    {
      q: "Can I switch plans anytime?",
      icon: <RotateCcw className="w-5 h-5 text-black dark:text-white" />,
      a: (
        <>
          Yes, you can upgrade or downgrade your plan at any time. Changes take effect immediately, and you'll be charged or credited prorated amounts.
        </>
      ),
    },
    {
      q: "What happens when I upgrade to Pro?",
      icon: <Gift className="w-5 h-5 text-black dark:text-white" />,
      a: (
        <>
          When you upgrade to Pro, you'll be charged immediately and gain instant access to all Pro features including unlimited business name generation, brand kit creation, business plan generator, and more.
        </>
      ),
    },
    {
      q: "What payment methods do you accept?",
      icon: <CreditCard className="w-5 h-5 text-black dark:text-white" />,
      a: (
        <>
          We accept all major credit cards (Visa, MasterCard, American Express) and PayPal. All payments are processed securely through Stripe.
        </>
      ),
    },
    {
      q: "Do you offer refunds?",
      icon: <Shield className="w-5 h-5 text-black dark:text-white" />,
      a: (
        <>
          Yes, we offer a 30-day money-back guarantee for all paid plans. If you're not satisfied, contact us for a full refund.
        </>
      ),
    },
    {
      q: "Free Plan",
      icon: <Star className="w-5 h-5 text-black dark:text-white" />,
      a: (
        <>
          <ul className="space-y-1">
            <li>• 3 Business Name generations</li>
            <li>• 1 Basic slogan</li>
            <li>• Logo previews (low-res)</li>
            <li>• Starter color palette (3 colors)</li>
            <li>• Lite profile only</li>
          </ul>
        </>
      ),
    },
    {
      q: "Pro Plan",
      icon: <Crown className="w-5 h-5 text-black dark:text-white" />,
      a: (
        <>
          <ul className="space-y-1 mb-4">
            <li>• Unlimited Business Name generations</li>
            <li>• Full logo pack (SVG/PNG, transparent)</li>
            <li>• Expanded color palettes + font pairings</li>
            <li>• Slogan Generator (Pro mode)</li>
            <li>• AI Frameworks Builder (Pro mode)</li>
            <li>• Export to PDF, DOCX, Google Docs</li>
            <li>• Profile sync across devices</li>
            <li>• Priority support + commercial usage rights</li>
            <li>• Access to all future Phase 2 features automatically</li>
          </ul>
          <p className="font-medium">👉 Tip: Start free to try the toolkit — upgrade to Pro anytime to unlock the full business development kit.</p>
        </>
      ),
    },
  ];

  const businessPlanBuilderUsageFaqs: QA[] = [
    {
      q: "What is the AI Business Plan Builder?",
      icon: <FileBarChart className="w-5 h-5 text-black dark:text-white" />,
      a: (
        <>
          <p className="mb-2">The AI Business Plan Builder is your step-by-step guide to creating a professional business plan without starting from scratch. Instead of facing a blank page, you fill out your Business Brief once (company name, model, offerings, market, etc.), and AI will draft each section of your plan. You can edit, regenerate, or save as you go.</p>
        </>
      ),
    },
    {
      q: "How do I use it?",
      icon: <Lightbulb className="w-5 h-5 text-black dark:text-white" />,
      a: (
        <>
          <p className="mb-3 font-medium">Fill out your Business Brief (at the top of the page).</p>
          <ul className="space-y-1 ml-4 mb-4">
            <li>• Add your company name, industry, model, offerings, market, and competitive edge.</li>
            <li>• Optional: include a financial headline (e.g., "Launch Q4 2025; 2026 $730k; 2027 $1.46M").</li>
          </ul>
          <p className="mb-2 font-medium">Select a section from the outline on the left.</p>
          <ul className="space-y-1 ml-4 mb-4">
            <li>• Executive Summary, Market Analysis, etc.</li>
          </ul>
          <p className="mb-2 font-medium">Click "AI Assist."</p>
          <ul className="space-y-1 ml-4 mb-4">
            <li>• AI will generate a draft using your Business Brief.</li>
            <li>• You can also add a short "Optional Prompt" if you want AI to focus on something specific.</li>
          </ul>
          <p className="mb-2 font-medium">Refine your draft.</p>
          <ul className="space-y-1 ml-4 mb-4">
            <li>• Use Rephrase, Expand, or Summarize, or just edit the text directly.</li>
          </ul>
          <p className="mb-2 font-medium">Save to Document.</p>
          <ul className="space-y-1 ml-4 mb-4">
            <li>• Your section will be stored and added to the full plan preview.</li>
          </ul>
          <p className="mb-2 font-medium">Preview Full Document anytime.</p>
          <ul className="space-y-1 ml-4">
            <li>• When you're ready, export your plan to Word or PDF.</li>
          </ul>
        </>
      ),
    },
    {
      q: "What if I click Save twice by accident?",
      icon: <ShieldCheck className="w-5 h-5 text-black dark:text-white" />,
      a: (
        <>
          <p>If you try to save the same content without changes, the system will ask: "No changes since last save. Do you still want to save it again?" This helps avoid duplicates in your plan.</p>
        </>
      ),
    },
    {
      q: "Do I have to write prompts?",
      icon: <HelpCircle className="w-5 h-5 text-black dark:text-white" />,
      a: (
        <>
          <p className="mb-2">No. If you leave the prompt box empty, AI will use your Business Brief to generate the section. But if you want extra control, you can add a short instruction (like "make it investor-friendly" or "list services as bullets").</p>
        </>
      ),
    },
  ];

  const samplePromptsFaqs: QA[] = [
    {
      q: "Executive Summary",
      icon: <FileText className="w-5 h-5 text-black dark:text-white" />,
      a: (
        <>
          <p className="font-mono text-sm bg-gray-100 dark:bg-gray-800 p-3 rounded">👉 "Generate a concise investor-ready overview of my company using the Business Brief."</p>
        </>
      ),
    },
    {
      q: "Company Overview",
      icon: <Building2 className="w-5 h-5 text-black dark:text-white" />,
      a: (
        <>
          <p className="font-mono text-sm bg-gray-100 dark:bg-gray-800 p-3 rounded">👉 "Describe the mission, vision, values, and structure of my company."</p>
        </>
      ),
    },
    {
      q: "Products & Services",
      icon: <Briefcase className="w-5 h-5 text-black dark:text-white" />,
      a: (
        <>
          <p className="font-mono text-sm bg-gray-100 dark:bg-gray-800 p-3 rounded">👉 "List my products and services as bullet points with short descriptions."</p>
        </>
      ),
    },
    {
      q: "Market Analysis",
      icon: <FileBarChart className="w-5 h-5 text-black dark:text-white" />,
      a: (
        <>
          <p className="font-mono text-sm bg-gray-100 dark:bg-gray-800 p-3 rounded">👉 "Summarize my target market, competitors, and industry trends."</p>
        </>
      ),
    },
    {
      q: "Marketing & Sales Strategy",
      icon: <Zap className="w-5 h-5 text-black dark:text-white" />,
      a: (
        <>
          <p className="font-mono text-sm bg-gray-100 dark:bg-gray-800 p-3 rounded">👉 "Outline how my company will attract and keep customers."</p>
        </>
      ),
    },
    {
      q: "Operations Plan",
      icon: <Clock className="w-5 h-5 text-black dark:text-white" />,
      a: (
        <>
          <p className="font-mono text-sm bg-gray-100 dark:bg-gray-800 p-3 rounded">👉 "Describe the systems, tools, and workflows my business uses to deliver services."</p>
        </>
      ),
    },
    {
      q: "Management & Organization",
      icon: <Building2 className="w-5 h-5 text-black dark:text-white" />,
      a: (
        <>
          <p className="font-mono text-sm bg-gray-100 dark:bg-gray-800 p-3 rounded">👉 "List the founders, key roles, and future hires with clear structure."</p>
        </>
      ),
    },
    {
      q: "Financial Plan",
      icon: <DollarSign className="w-5 h-5 text-black dark:text-white" />,
      a: (
        <>
          <p className="font-mono text-sm bg-gray-100 dark:bg-gray-800 p-3 rounded">👉 "Create a simple Launch / Growth / Scale projection using my financial headline."</p>
        </>
      ),
    },
    {
      q: "Funding Request",
      icon: <DollarSign className="w-5 h-5 text-black dark:text-white" />,
      a: (
        <>
          <p className="font-mono text-sm bg-gray-100 dark:bg-gray-800 p-3 rounded">👉 "Write an optional funding request section that explains how capital would be used."</p>
        </>
      ),
    },
    {
      q: "Appendix",
      icon: <FileText className="w-5 h-5 text-black dark:text-white" />,
      a: (
        <>
          <p className="font-mono text-sm bg-gray-100 dark:bg-gray-800 p-3 rounded">👉 "Add placeholders for charts, graphs, and supporting documents."</p>
        </>
      ),
    },
    {
      q: "Milestones / Roadmap",
      icon: <Clock className="w-5 h-5 text-black dark:text-white" />,
      a: (
        <>
          <p className="font-mono text-sm bg-gray-100 dark:bg-gray-800 p-3 rounded">👉 "List key milestones for launch, growth, and scale phases."</p>
        </>
      ),
    },
    {
      q: "Exit Strategy (Optional)",
      icon: <FileBarChart className="w-5 h-5 text-black dark:text-white" />,
      a: (
        <>
          <p className="font-mono text-sm bg-gray-100 dark:bg-gray-800 p-3 rounded">👉 "Provide a brief exit strategy such as acquisition or IPO."</p>
        </>
      ),
    },
  ];

  const businessPlanBuilderFaqs: QA[] = [
    {
      q: "What is IBrandBiz AI Frameworks Builder?",
      icon: <FileBarChart className="w-5 h-5 text-black dark:text-white" />,
      a: (
        <>
          <p className="mb-2">The AI Frameworks Builder is a simple, guided tool that helps you create professional business plans without needing to start from scratch.</p>
          <p>It combines customizable outlines, AI writing support, and visual templates so you can turn your ideas into an investor-ready plan quickly.</p>
        </>
      ),
    },
    {
      q: "How do I create my first business plan?",
      icon: <Star className="w-5 h-5 text-black dark:text-white" />,
      a: (
        <>
          <p className="mb-2">After logging in, just click "Start My Plan." You'll see a ready-made outline (Executive Summary, Market Analysis, etc.).</p>
          <p>From there, you can edit, add, or remove sections to fit your business. The AI Writing Assistant is available to help you fill in each part.</p>
        </>
      ),
    },
    {
      q: "How do I add, move, or delete sections in my plan?",
      icon: <FileText className="w-5 h-5 text-black dark:text-white" />,
      a: (
        <>
          <p className="mb-2">Go to the Outline tab. Each section has drag-and-drop handles and edit icons.</p>
          <p>Use these to rearrange or remove sections. To add a new section, click "Add Chapter" and pick from our templates.</p>
        </>
      ),
    },
    {
      q: "Can I customize the cover page with my logo and colors?",
      icon: <Palette className="w-5 h-5 text-black dark:text-white" />,
      a: (
        <>
          <p>Yes! In the Cover tab, you can choose from multiple design layouts. Add your business name, tagline, logo, and adjust colors and fonts to match your branding.</p>
        </>
      ),
    },
    {
      q: "How do I use the AI to rewrite or expand my content?",
      icon: <Zap className="w-5 h-5 text-black dark:text-white" />,
      a: (
        <>
          <p className="mb-2">Highlight a section and click "Write with AI." You'll see options to summarize, expand, simplify, or rewrite in different styles.</p>
          <p>You can instantly generate text that's tailored to your business.</p>
        </>
      ),
    },
    {
      q: "What tone options are available (persuasive, professional, friendly, etc.)?",
      icon: <Lightbulb className="w-5 h-5 text-black dark:text-white" />,
      a: (
        <>
          <p className="mb-2">You can choose from tones like:</p>
          <ul className="space-y-1 ml-4">
            <li>• Formal (professional reports)</li>
            <li>• Friendly/Conversational (casual and approachable)</li>
            <li>• Persuasive (ideal for convincing investors)</li>
            <li>• Inspirational (motivating and visionary)</li>
            <li>• Technical (industry-specific language)</li>
          </ul>
        </>
      ),
    },
    {
      q: "How do I create a SWOT analysis or customer persona chart?",
      icon: <FileBarChart className="w-5 h-5 text-black dark:text-white" />,
      a: (
        <>
          <p className="mb-2">On the right-hand panel, select SWOT Analysis or Customer Persona.</p>
          <p>A drag-and-drop template opens where you can fill in strengths, weaknesses, opportunities, threats—or customer details like demographics and needs.</p>
        </>
      ),
    },
    {
      q: "Can I add my own charts or import data from Excel?",
      icon: <FileText className="w-5 h-5 text-black dark:text-white" />,
      a: (
        <>
          <p>Yes. Use the Import Excel option under the right-hand panel. You can upload your own financial data, and it will automatically generate charts inside your plan.</p>
        </>
      ),
    },
    {
      q: "How do I download my business plan as a PDF or Word document?",
      icon: <FileBarChart className="w-5 h-5 text-black dark:text-white" />,
      a: (
        <>
          <p>Go to the Download tab. Select your preferred format (PDF or DOCX), pick the sections you want included, and hit Download. Your styled, formatted plan will be ready in seconds.</p>
        </>
      ),
    },
    {
      q: "Can I choose which sections to include when exporting?",
      icon: <HelpCircle className="w-5 h-5 text-black dark:text-white" />,
      a: (
        <>
          <p>Yes. In the Download tab, use the toggles to turn sections on or off before exporting. You can also choose paper size, fonts, and spacing for a fully customized export.</p>
        </>
      ),
    },
  ];

  const businessFaqs: QA[] = [
    {
      q: "Do I need an LLC for my small business?",
      icon: <Building2 className="w-5 h-5 text-black dark:text-white" />,
      a: (
        <>
          You can start as a sole proprietor (simplest) and upgrade later. An LLC can help separate
          personal and business liability and may provide tax flexibility. Compare structures via the{" "}
          <a className="text-blue-600 hover:underline" href="https://www.sba.gov/business-guide/launch/choose-business-structure" target="_blank" rel="noopener noreferrer">
            SBA guide
          </a>{" "}
          and check your state's filing costs.
        </>
      ),
    },
    {
      q: "What's the difference between a DBA and an LLC?",
      icon: <FileText className="w-5 h-5 text-black dark:text-white" />,
      a: (
        <>
          A DBA ("Doing Business As") is just a <em>name</em> registration—no liability protection.
          An LLC is a legal entity that can protect your personal assets and often looks more
          professional to banks and partners.
        </>
      ),
    },
    {
      q: "When should I file a trademark?",
      icon: <Gavel className="w-5 h-5 text-black dark:text-white" />,
      a: (
        <>
          File once you're confident in your brand name/logo and plan to use it in commerce. Start
          with a search on{" "}
          <a className="text-blue-600 hover:underline" href="https://tmsearch.uspto.gov/" target="_blank" rel="noopener noreferrer">
            USPTO TESS
          </a>{" "}
          to spot conflicts. If it's clear, consider filing at{" "}
          <a className="text-blue-600 hover:underline" href="https://www.uspto.gov/trademarks/apply" target="_blank" rel="noopener noreferrer">
            USPTO
          </a>
          . (Tip: avoid generic/descriptive names—they're harder to protect.)
        </>
      ),
    },
    {
      q: "How do I get an EIN (Employer ID Number)?",
      icon: <DollarSign className="w-5 h-5 text-black dark:text-white" />,
      a: (
        <>
          It's free and fast with the IRS—apply online here:{" "}
          <a
            className="text-blue-600 hover:underline"
            href="https://www.irs.gov/businesses/small-businesses-self-employed/apply-for-an-employer-identification-number-ein-online"
            target="_blank"
            rel="noopener noreferrer"
          >
            IRS EIN Application
          </a>
          . You'll need it for business bank accounts and tax filings.
        </>
      ),
    },
    {
      q: "How long does formation usually take?",
      icon: <Clock className="w-5 h-5 text-black dark:text-white" />,
      a: (
        <>
          It varies by state. Online filings can be same-day to a couple of weeks. Expedited service
          is often available for an extra fee. Check your Secretary of State processing times.
        </>
      ),
    },
    {
      q: "How do I reduce risk when choosing a name?",
      icon: <ShieldCheck className="w-5 h-5 text-black dark:text-white" />,
      a: (
        <>
          Do a quick name screening: domain search, social handles, and a basic{" "}
          <a className="text-blue-600 hover:underline" href="https://tmsearch.uspto.gov/" target="_blank" rel="noopener noreferrer">
            USPTO trademark search
          </a>
          . Avoid names close to existing brands in your niche.
        </>
      ),
    },
    {
      q: "Can I form in a different state (e.g., Delaware)?",
      icon: <Briefcase className="w-5 h-5 text-black dark:text-white" />,
      a: (
        <>
          You can, but if you <em>operate</em> mainly in your home state, you may still need to
          register there as a foreign entity. Weigh fees, taxes, and compliance before choosing.
        </>
      ),
    },
    {
      q: "Any mentorship or guidance?",
      icon: <BookOpen className="w-5 h-5 text-black dark:text-white" />,
      a: (
        <>
          Yes—check out{" "}
          <a className="text-blue-600 hover:underline" href="https://www.score.org/find-mentor" target="_blank" rel="noopener noreferrer">
            SCORE mentorship
          </a>{" "}
          and your local Small Business Development Center (SBDC). They offer free coaching and workshops.
        </>
      ),
    },
    {
      q: "How do I research my competition?",
      icon: <Search className="w-5 h-5 text-black dark:text-white" />,
      a: (
        <>
          Scan top Google results, social channels, review sites, and ad libraries. Map their
          positioning and offers. Use our Business Plan tool to turn insights into a strategy.
        </>
      ),
    },
  ];
  return (
    <TemplatePage 
      bannerTitle="Frequently Asked Questions" 
      bannerSubtitle="Get answers to common questions about IBrandBiz"
      bannerImage={faqsImage}
    >
      <section className="max-w-4xl mx-auto py-12 space-y-12">
        
        {/* Welcome Message */}
        <div className="mb-12">
          <p className="text-lg text-gray-700 dark:text-gray-300 leading-relaxed">
            Welcome to IBrandBiz — your complete business branding toolkit. Here's a quick guide on how to use each part of the system.
          </p>
        </div>

        {/* How to Use Our System Section */}
        <div className="border-b border-gray-200 dark:border-gray-700 pb-4 mb-8">
          <h2 className="text-2xl font-bold text-gray-900 dark:text-white">How to Use Our System</h2>
        </div>

        <div className="space-y-6 mb-12">
          <Accordion items={systemUsageFaqs} />
        </div>

        {/* Presentation Templates Section */}
        <div className="border-b border-gray-200 dark:border-gray-700 pb-4 mb-8">
          <h2 className="text-2xl font-bold text-gray-900 dark:text-white">📑 Presentation Templates</h2>
        </div>

        <div className="space-y-6 mb-12">
          <Accordion items={presentationTemplatesFaqs} />
        </div>

        {/* Business Formation Section */}
        <div className="border-b border-gray-200 dark:border-gray-700 pb-4 mb-8">
          <h2 className="text-2xl font-bold text-gray-900 dark:text-white">Business Formation</h2>
        </div>

        <div className="space-y-6">
          <Accordion items={businessFaqs} />
        </div>

        {/* Subscriptions Section */}
        <div className="border-b border-gray-200 dark:border-gray-700 pb-4 mb-8 pt-12">
          <h2 className="text-2xl font-bold text-gray-900 dark:text-white">Subscriptions</h2>
        </div>

        <div className="space-y-6">
          <Accordion items={subscriptionFaqs} />
        </div>

        {/* How to Use the AI Business Plan Builder Section */}
        <div className="border-b border-gray-200 dark:border-gray-700 pb-4 mb-8 pt-12">
          <h2 className="text-2xl font-bold text-gray-900 dark:text-white">How to Use the AI Business Plan Builder</h2>
        </div>

        <div className="space-y-6">
          <Accordion items={businessPlanBuilderUsageFaqs} />
        </div>

        {/* Sample Prompts for Each Section */}
        <div className="border-b border-gray-200 dark:border-gray-700 pb-4 mb-8 pt-12">
          <h2 className="text-2xl font-bold text-gray-900 dark:text-white">Sample Prompts for Each Section</h2>
          <p className="text-sm text-gray-600 dark:text-gray-400 mt-2">Copy/paste these examples when testing or writing your plan:</p>
        </div>

        <div className="space-y-6">
          <Accordion items={samplePromptsFaqs} />
        </div>

        {/* AI Frameworks Builder Section */}
        <div className="border-b border-gray-200 dark:border-gray-700 pb-4 mb-8 pt-12">
          <h2 className="text-2xl font-bold text-gray-900 dark:text-white">AI Frameworks Builder</h2>
        </div>

        <div className="space-y-6">
          <Accordion items={businessPlanBuilderFaqs} />
        </div>

      </section>
    </TemplatePage>
  );
}