import TemplatePage from "@/components/TemplatePage";
import { privacyImage } from "@/assets";

/* ============================ Config ============================ */
const COMPANY_NAME = "IBrandBiz";
const CONTACT_EMAIL = "privacy@ibrandbiz.com";
const EFFECTIVE_DATE = "2025-09-13";

/* ======================= Cookie Policy Page ===================== */
function CookiePolicyPage() {
  return (
    <main className="mx-auto max-w-4xl px-6 py-12 text-slate-800 dark:text-slate-200">
      <header className="mb-8">
        <p className="text-xs uppercase tracking-wider text-slate-500 dark:text-slate-400">Cookie Policy</p>
        <h1 className="mt-1 text-3xl font-extrabold text-[#03222e] dark:text-white">{COMPANY_NAME} Cookie Policy</h1>
        <p className="mt-2 text-sm text-slate-600 dark:text-slate-400">Effective date: {EFFECTIVE_DATE}</p>
      </header>

      <Section title="What are cookies?">
        <p>
          Cookies are small text files placed on your device by a website. They help the site function, remember preferences,
          and understand how people use the site. Similar technologies (like local storage, pixels, and beacons) are used for
          the same purposes; we refer to them collectively as "cookies."
        </p>
      </Section>

      <Section title="How we use cookies">
        <ul className="list-disc pl-6 space-y-2">
          <li><strong>Essential:</strong> required for core functions like navigation, authentication, and security.</li>
          <li><strong>Analytics:</strong> to understand site usage and improve features and performance.</li>
          <li><strong>Marketing:</strong> to measure campaigns and show relevant content (if you opt in).</li>
        </ul>
      </Section>

      <Section title="Your choices">
        <p className="mb-2">
          On your first visit, we ask for your cookie preferences. You can update your choices anytime by clearing consent in
          your browser storage or via a future in‑app settings toggle. Essential cookies are always on because the site won't
          work without them.
        </p>
        <p className="text-sm text-slate-600 dark:text-slate-400">
          Note: Disabling analytics or marketing may impact personalization and measurement features.
        </p>
      </Section>

      <Section title="Third‑party cookies">
        <p className="mb-2">
          We may use third‑party services that set cookies when enabled. Examples include analytics providers and advertising
          partners. These providers have their own privacy/cookie notices.
        </p>
      </Section>

      <Section title="Changes to this policy">
        <p>
          We may update this Cookie Policy from time to time. We will post any changes on this page and update the effective
          date above.
        </p>
      </Section>

      <Section title="Contact us">
        <p>
          Questions? Email <a className="text-[#05445e] dark:text-[#189ab4] underline hover:opacity-80" href={`mailto:${CONTACT_EMAIL}`}>{CONTACT_EMAIL}</a>.
        </p>
      </Section>
    </main>
  );
}

function Section({ title, children }: { title: string; children: React.ReactNode }) {
  return (
    <section className="mt-10">
      <h2 className="text-xl font-bold text-[#03222e] dark:text-white">{title}</h2>
      <div className="mt-3 text-slate-700 dark:text-slate-300 text-[15px] leading-7">{children}</div>
    </section>
  );
}

export default function CookiesPage() {
  return (
    <TemplatePage
      bannerTitle="Cookie Policy"
      bannerSubtitle="Learn about how we use cookies to improve your experience on our website"
      bannerImage={privacyImage}
    >
      <CookiePolicyPage />
    </TemplatePage>
  );
}