import { useState, useEffect } from "react";
import { signInAdminWithGoogle } from "@/admin/firebaseClient";
import { setAdminTokenFromFirebase } from "@/admin/adminGuard";

export default function AdminLogin() {
  const [err, setErr] = useState<string | null>(null);
  const [checking, setChecking] = useState(true);

  useEffect(() => {
    const checkExistingAuth = async () => {
      try {
        // Check if user is already authenticated with admin privileges
        const token = await setAdminTokenFromFirebase();
        if (token) {
          // User already has admin privileges, redirect to dashboard
          window.location.href = "/admin/dashboard";
          return;
        }
      } catch (error) {
        console.log('No existing admin auth found');
      }
      setChecking(false);
    };

    checkExistingAuth();
  }, []);

  const handleSignIn = async () => {
    try {
      const token = await signInAdminWithGoogle();       // gets Firebase ID token w/ admin claim
      sessionStorage.setItem("adminToken", token);
      window.location.href = "/admin/dashboard";
    } catch (e: any) {
      setErr(e.message || "Sign-in failed");
    }
  };

  if (checking) {
    return (
      <div className="max-w-md mx-auto py-12">
        <div className="text-center">
          <div className="animate-spin h-8 w-8 border-2 border-primary border-t-transparent rounded-full mx-auto"></div>
          <p className="mt-2 text-gray-600">Checking authentication...</p>
        </div>
      </div>
    );
  }

  return (
    <div className="max-w-md mx-auto py-12">
      <h1 className="text-2xl font-bold mb-2">Staff Admin</h1>
      <p className="text-sm text-gray-600 mb-6">Company-only access</p>
      <button className="rounded-xl bg-black text-white px-4 py-2" onClick={handleSignIn}>
        Sign in with Google (Staff)
      </button>
      {err && <div className="mt-4 text-red-600 text-sm">{err}</div>}
    </div>
  );
}