import TemplatePage from "@/components/TemplatePage";
import { CheckCircle } from "lucide-react";
import { aboutUsImage, whoAreWeImage, ourMissionImage, ourVisionImage, teamImage } from "@/assets";

export default function About() {
  return (
    <TemplatePage
      bannerTitle="About IBrandBiz"
      bannerSubtitle="Empowering entrepreneurs and businesses of all sizes to build impactful brands that resonate with their audience and drive meaningful growth."
      bannerImage={aboutUsImage}
    >
      {/* About Content Section */}
      <section className="bg-white dark:bg-gray-800 pt-12 pb-16" data-testid="section-about-content">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">

          {/* Our Story Section */}
          <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center mb-16">
            <div className="order-2 lg:order-1">
              <img 
                src={whoAreWeImage} 
                alt="Who We Are" 
                className="w-full h-64 object-cover rounded-lg"
              />
            </div>
            <div className="order-1 lg:order-2">
              <h2 className="text-2xl font-bold text-gray-900 dark:text-white mb-6">
                OUR STORY
              </h2>
              <p className="text-base text-gray-600 dark:text-gray-300 leading-relaxed mb-4">
                Founded in 2019 by Jay Richards in Houston, Texas, IBrandBiz has grown into a comprehensive design and branding hub dedicated to helping businesses make a lasting impression. We deliver end-to-end solutions—from logos and brand kits to websites, social media assets, and hosting—that empower brands to stand out in a competitive market.
              </p>
              <p className="text-base text-gray-600 dark:text-gray-300 leading-relaxed">
                Our approach blends personalized service with modern design tools, ensuring every project reflects our clients' unique vision, voice, and goals.
              </p>
            </div>
          </div>

          {/* Our Mission Section */}
          <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center mb-16">
            <div className="order-1 lg:order-1">
              <h2 className="text-2xl font-bold text-gray-900 dark:text-white mb-6">
                OUR MISSION
              </h2>
              <p className="text-base text-gray-600 dark:text-gray-300 leading-relaxed mb-4">
                At IBrandBiz, our mission is to empower entrepreneurs and businesses of all sizes to build impactful brands that resonate with their audience and drive meaningful growth. We believe that strong branding is the foundation of business success, and we're committed to making professional design and branding services accessible, affordable, and effective.
              </p>
              <div className="space-y-3">
                <div className="flex items-center space-x-3">
                  <CheckCircle className="h-5 w-5 text-primary" />
                  <span className="text-gray-600 dark:text-gray-300">Professional design made accessible</span>
                </div>
                <div className="flex items-center space-x-3">
                  <CheckCircle className="h-5 w-5 text-primary" />
                  <span className="text-gray-600 dark:text-gray-300">Tailored solutions for every business</span>
                </div>
                <div className="flex items-center space-x-3">
                  <CheckCircle className="h-5 w-5 text-primary" />
                  <span className="text-gray-600 dark:text-gray-300">Results-driven creative strategies</span>
                </div>
              </div>
            </div>
            <div className="order-2 lg:order-2">
              <img 
                src={ourMissionImage} 
                alt="Our Mission" 
                className="w-full h-64 object-cover rounded-lg"
              />
            </div>
          </div>

          {/* Our Vision Section */}
          <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center mb-16">
            <div className="order-2 lg:order-1">
              <img 
                src={ourVisionImage} 
                alt="Our Vision" 
                className="w-full h-64 object-cover rounded-lg"
              />
            </div>
            <div className="order-1 lg:order-2">
              <h2 className="text-2xl font-bold text-gray-900 dark:text-white mb-6">
                OUR VISION
              </h2>
              <p className="text-base text-gray-600 dark:text-gray-300 leading-relaxed mb-4">
                We envision a world where every business, regardless of size or budget, has access to professional branding that truly represents who they are and what they stand for. Our goal is to be the go-to platform for entrepreneurs looking to establish their brand identity quickly, affordably, and with confidence.
              </p>
              <p className="text-base text-gray-600 dark:text-gray-300 leading-relaxed">
                Through innovation, creativity, and a deep understanding of market dynamics, we aim to democratize professional branding and help shape the visual landscape of tomorrow's most successful companies.
              </p>
            </div>
          </div>

          {/* Meet Our Team Section */}
          <div className="mb-16">
            <h2 className="text-2xl font-bold text-gray-900 dark:text-white mb-8 text-left">
              MEET OUR TEAM
            </h2>
            <div className="mb-8">
              <p className="text-base text-gray-600 dark:text-gray-300 leading-relaxed text-left">
                IBrandBiz operates as a lean, agile network of creative professionals and strategic partners. Rather than maintaining a large internal team, we work with a carefully curated network of designers, developers, copywriters, and brand strategists who share our commitment to excellence and innovation.
              </p>
            </div>
            <div className="mb-8">
              <p className="text-base text-gray-600 dark:text-gray-300 leading-relaxed text-left">
                This flexible model allows us to scale quickly, assembling the right team for every client's unique needs while maintaining the same high standards of quality, creativity, and personal service that define IBrandBiz.
              </p>
            </div>
            
            <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-start">
              <div className="order-2 lg:order-1">
                <img 
                  src={teamImage} 
                  alt="Meet Our Team" 
                  className="w-full h-64 object-cover rounded-lg"
                />
              </div>
              <div className="order-1 lg:order-2">
                <h3 className="text-xl font-bold text-gray-900 dark:text-white mb-4">
                  JAY RICHARDS – FOUNDER & VISIONARY
                </h3>
                <p className="text-base text-gray-600 dark:text-gray-300 leading-relaxed mb-6">
                  With over 25 years of experience in graphic design, web design, and digital marketing, Jay brings both expertise and passion to every project. A graduate in Graphic Design, he has worked across industries helping businesses establish impactful brand identities and strong digital footprints.
                </p>
                <p className="text-base text-gray-600 dark:text-gray-300 leading-relaxed mb-6">
                  Beyond his professional achievements, Jay champions inclusion and diversity, fostering a collaborative environment that embraces unique perspectives and talents.
                </p>
                <p className="text-base text-gray-600 dark:text-gray-300 leading-relaxed">
                  Jay's mission is simple: to combine creativity with strategy, delivering services that are not only beautiful but also effective—helping clients grow, connect, and thrive.
                </p>
              </div>
            </div>
          </div>
        </div>
      </section>
    </TemplatePage>
  );
}