import { Link } from "wouter";
import { Button } from "@/components/ui/button";

function ServiceCard({ eyebrow, title, description, bullets, ctaLabel, href, tone }: {
  eyebrow: string;
  title: string;
  description: string;
  bullets: string[];
  ctaLabel: string;
  href: string;
  tone: string;
}) {
  const toneColors = {
    teal: "from-teal-500 to-cyan-500",
    navy: "from-blue-800 to-blue-600", 
    orange: "from-orange-500 to-red-500"
  };

  return (
    <div className="p-6 border rounded-lg bg-white dark:bg-gray-800 shadow-sm hover:shadow-md transition-shadow">
      <div className="text-sm font-medium text-primary mb-2">{eyebrow}</div>
      <h3 className="text-xl font-bold text-gray-900 dark:text-white mb-3">{title}</h3>
      <p className="text-gray-600 dark:text-gray-300 mb-4">{description}</p>
      <ul className="space-y-2 mb-6">
        {bullets.map((bullet, idx) => (
          <li key={idx} className="flex items-start gap-2 text-sm text-gray-600 dark:text-gray-300">
            <span className="w-1.5 h-1.5 bg-primary rounded-full mt-2 flex-shrink-0" />
            {bullet}
          </li>
        ))}
      </ul>
      <Link href={href}>
        <Button className={`w-full bg-gradient-to-r ${toneColors[tone as keyof typeof toneColors]} hover:opacity-90 text-white`}>
          {ctaLabel}
        </Button>
      </Link>
    </div>
  );
}

export default function Services() {
  return (
    <section id="services" className="py-16 bg-white dark:bg-gray-800">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="text-center mb-12">
          <h2 className="text-3xl md:text-4xl font-bold text-gray-900 dark:text-white mb-4">
            Make Your First Impression Your Best — from Name to Domain
          </h2>
          <p className="text-lg text-muted-foreground max-w-3xl mx-auto">
            From naming to slogans and domains, we give you everything you need to launch and grow your brand with confidence.
          </p>
        </div>
        
        <div className="grid gap-6 md:grid-cols-3">
          <ServiceCard
            eyebrow="Brand Name Wizard"
            title="Find a Name People Remember"
            description="AI-powered name ideas based on your keywords, industry, and vibe. Instantly generate unique, brandable names with matching domain suggestions."
            bullets={[
              "Smart prompts tuned for memorability",
              "Instant shortlist with save + copy",
              "Checks domain availability hints"
            ]}
            ctaLabel="Try the Wizard"
            href="/name-wizard"
            tone="teal"
          />

          <ServiceCard
            eyebrow="Slogan Generator"
            title="Craft the Perfect Tagline"
            description="AI-powered slogans that capture your brand's essence. Generate memorable taglines that connect with your audience and make your brand stick."
            bullets={[
              "Smart prompts based on your industry",
              "Multiple creative variations",
              "Copy & save your favorites instantly"
            ]}
            ctaLabel="Generate Slogans"
            href="/slogans"
            tone="navy"
          />

          <ServiceCard
            eyebrow="Domains"
            title="Secure the Perfect Domain"
            description="Search and secure your domain with our GoDaddy-powered lookup. Lock in your brand's home online before someone else does."
            bullets={[
              "Fast search with sensible suggestions",
              "Filters for extensions (.com, .io, .co)",
              "Straightforward checkout handoff"
            ]}
            ctaLabel="Search Domains"
            href="/web-services/domains"
            tone="orange"
          />
        </div>
      </div>
    </section>
  );
}