import { Link } from "wouter";
import { Button } from "@/components/ui/button";

function ProductCard({ eyebrow, title, desc, bullets, href, tone }: {
  eyebrow: string;
  title: string;
  desc: string;
  bullets: string[];
  href: string;
  tone: string;
}) {
  const toneColors = {
    teal: "from-teal-500 to-cyan-500",
    navy: "from-blue-800 to-blue-600"
  };

  return (
    <div className="p-6 border rounded-lg bg-white dark:bg-gray-800 shadow-sm hover:shadow-md transition-shadow">
      <div className="text-sm font-medium text-primary mb-2">{eyebrow}</div>
      <h3 className="text-xl font-bold text-gray-900 dark:text-white mb-3">{title}</h3>
      <p className="text-gray-600 dark:text-gray-300 mb-4">{desc}</p>
      <ul className="space-y-2 mb-6">
        {bullets.map((bullet, idx) => (
          <li key={idx} className="flex items-start gap-2 text-sm text-gray-600 dark:text-gray-300">
            <span className="w-1.5 h-1.5 bg-primary rounded-full mt-2 flex-shrink-0" />
            {bullet}
          </li>
        ))}
      </ul>
      <Link href={href}>
        <Button className={`w-full bg-gradient-to-r ${toneColors[tone as keyof typeof toneColors]} hover:opacity-90 text-white`}>
          Explore {eyebrow}
        </Button>
      </Link>
    </div>
  );
}

export default function Products() {
  return (
    <section id="products" className="py-16 bg-gray-50 dark:bg-gray-900">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="text-center mb-12">
          <h2 className="text-3xl md:text-4xl font-bold text-gray-900 dark:text-white mb-4">
            Everything You Need to Build Your Brand
          </h2>
          <p className="text-lg text-muted-foreground max-w-3xl mx-auto">
            Pick a product category to start fast and grow with confidence.
          </p>
        </div>
        
        <div className="grid gap-6 md:grid-cols-3">
          <ProductCard
            eyebrow="Brand Kits"
            title="Complete Identity Packages"
            desc="Logos, color palettes, type styles, and usage guides — bundled and ready to apply across your business."
            bullets={[
              "Multiple logo variations",
              "Color + typography guidance",
              "Export-ready files (PNG/SVG/PDF)",
            ]}
            href="/brand-kit"
            tone="teal"
          />

          <ProductCard
            eyebrow="AI Business Plan Developer"
            title="Professional Business Plans Made Easy"
            desc="AI-powered business plan creation with comprehensive templates, financial projections, and export options for investors and lenders."
            bullets={[
              "AI-guided plan development",
              "Financial projections & models",
              "Export to PDF, DOCX, Google Docs",
            ]}
            href="/plan"
            tone="navy"
          />

          <ProductCard
            eyebrow="Templates"
            title="Professional Business Templates"
            desc="Ready-made templates for presentations, cover pages, business plans, and logos to elevate your brand materials."
            bullets={[
              "Business Plan Templates",
              "Business Plan & Logo Templates",
            ]}
            href="/business-assets/templates/business-plan"
            tone="teal"
          />

        </div>
      </div>
    </section>
  );
}