import GlobalSlider from "@/components/GlobalSlider";
import SearchBar from "@/components/SearchBar";
import FeatureTiles from "@/components/FeatureTiles";
import { homeSlides } from "@/data/homeSlides";

export default function Hero() {
  return (
    <section id="hero" className="min-h-screen">
      {/* Hero Slider Section */}
      <div className="mt-6">
        <GlobalSlider 
          slides={homeSlides.filter(slide => slide.enabled !== false)} 
          autoPlay={true} 
          interval={10000} 
        />
      </div>
      
      {/* Search Bar Section */}
      <div className="bg-gray-50 dark:bg-gray-900">
        <SearchBar />
      </div>
      
      {/* Feature Tiles Section */}
      <div className="bg-white dark:bg-gray-800">
        <FeatureTiles />
      </div>
      
      {/* Value Proposition Section */}
      <div className="bg-gradient-to-br from-primary/5 to-accent/5 py-16">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
          <h2 className="text-3xl md:text-4xl font-bold text-gray-900 dark:text-white mb-6">
            Why Choose IBrandBiz?
          </h2>
          <div className="grid grid-cols-1 md:grid-cols-3 gap-8">
            <div className="flex flex-col items-center">
              <div className="w-16 h-16 bg-white border-2 border-accent rounded-full flex items-center justify-center mb-4">
                <span className="text-2xl">🤖</span>
              </div>
              <h3 className="text-xl font-semibold mb-2">AI-Powered</h3>
              <p className="text-muted-foreground">
                Advanced AI algorithms create unique, memorable names and designs tailored to your business.
              </p>
            </div>
            <div className="flex flex-col items-center">
              <div className="w-16 h-16 bg-white border-2 border-primary rounded-full flex items-center justify-center mb-4">
                <span className="text-2xl">⚡</span>
              </div>
              <h3 className="text-xl font-semibold mb-2">Instant Results</h3>
              <p className="text-muted-foreground">
                Get professional-quality brand assets in minutes, not weeks. No waiting, no delays.
              </p>
            </div>
            <div className="flex flex-col items-center">
              <div className="w-16 h-16 bg-white border-2 border-secondary rounded-full flex items-center justify-center mb-4">
                <span className="text-2xl">🎯</span>
              </div>
              <h3 className="text-xl font-semibold mb-2">All-in-One</h3>
              <p className="text-muted-foreground">
                From business names to domains to complete brand kits — everything you need in one place.
              </p>
            </div>
          </div>
          
          {/* Stats */}
          <div className="grid grid-cols-2 md:grid-cols-4 gap-6 mt-12 pt-8 border-t border-gray-200 dark:border-gray-600">
            <div className="text-center">
              <div className="text-3xl font-bold text-primary">10k+</div>
              <div className="text-muted-foreground">Names Generated</div>
            </div>
            <div className="text-center">
              <div className="text-3xl font-bold text-primary">5k+</div>
              <div className="text-muted-foreground">Domains Registered</div>
            </div>
            <div className="text-center">
              <div className="text-3xl font-bold text-primary">2k+</div>
              <div className="text-muted-foreground">Brand Kits Created</div>
            </div>
            <div className="text-center">
              <div className="text-3xl font-bold text-primary">3+</div>
              <div className="text-muted-foreground">Years Experience</div>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
}