import Accordion, { QA } from "@/components/ui/Accordion";
import { Briefcase, Lightbulb, Globe, Zap, Palette, FileBarChart, DollarSign, Shield, Clock, RotateCcw } from "lucide-react";

export default function FAQ() {
  const systemUsageFaqs: QA[] = [
    {
      q: "Brand Name Wizard",
      icon: <Lightbulb className="w-5 h-5 text-black dark:text-white" />,
      a: (
        <>
          <p className="mb-2">Enter a few keywords that describe your business.</p>
          <p className="mb-2">Our AI will generate unique, memorable business name options.</p>
          <p>Save your favorite names directly into your dashboard for later use.</p>
        </>
      ),
    },
    {
      q: "Domains",
      icon: <Globe className="w-5 h-5 text-black dark:text-white" />,
      a: (
        <>
          <p className="mb-2">Search available domain names that match your chosen business name.</p>
          <p className="mb-2">Instantly check availability and lock in your brand's online presence.</p>
          <p>This tool helps you ensure your business name and website stay consistent.</p>
        </>
      ),
    },
    {
      q: "Brand Kit",
      icon: <Palette className="w-5 h-5 text-black dark:text-white" />,
      a: (
        <>
          <p className="mb-2">Start with your business name and slogan.</p>
          <p className="mb-2">The generator will create a full identity kit: logos, color palettes, and fonts.</p>
          <p>Download and use your brand kit across websites, social media, and print.</p>
        </>
      ),
    },
  ];

  const pricingFaqs: QA[] = [
    {
      q: "What's included in the Free plan?",
      icon: <DollarSign className="w-5 h-5 text-black dark:text-white" />,
      a: (
        <>
          <p className="mb-2">The Free plan includes basic name generation, 5 brand kit downloads, and access to standard templates.</p>
          <p>Perfect for testing our platform and getting started with your brand.</p>
        </>
      ),
    },
    {
      q: "Can I cancel my Pro subscription anytime?",
      icon: <RotateCcw className="w-5 h-5 text-black dark:text-white" />,
      a: (
        <>
          <p className="mb-2">Yes, you can cancel your Pro subscription at any time.</p>
          <p>You'll continue to have access until the end of your current billing period.</p>
        </>
      ),
    },
    {
      q: "How secure is my data?",
      icon: <Shield className="w-5 h-5 text-black dark:text-white" />,
      a: (
        <>
          <p className="mb-2">We take data security seriously and use industry-standard encryption.</p>
          <p>Your business information and generated content are stored securely and never shared.</p>
        </>
      ),
    },
  ];

  return (
    <section id="faq" className="py-16 bg-gray-50 dark:bg-gray-900">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="text-center mb-12">
          <h2 className="text-3xl md:text-4xl font-bold text-gray-900 dark:text-white mb-4">
            Frequently Asked Questions
          </h2>
          <p className="text-lg text-muted-foreground max-w-3xl mx-auto">
            Get answers to common questions about our platform and services.
          </p>
        </div>

        <div className="grid gap-8 lg:grid-cols-2">
          <div>
            <h3 className="text-xl font-semibold mb-6 text-gray-900 dark:text-white">How to Use Our Tools</h3>
            <Accordion items={systemUsageFaqs} />
          </div>

          <div>
            <h3 className="text-xl font-semibold mb-6 text-gray-900 dark:text-white">Pricing & Plans</h3>
            <Accordion items={pricingFaqs} />
          </div>
        </div>
      </div>
    </section>
  );
}