import { createRoot } from "react-dom/client";
import App from "./App";
import "./index.css";
import "./app/spa404-listener";

// Handle unhandled promise rejections globally
window.addEventListener('unhandledrejection', (event) => {
  // Check if it's a network fetch error that we've already handled
  if (event.reason?.message?.includes('Failed to fetch') && 
      event.reason?.stack?.includes('firebase-templates.ts')) {
    console.warn('Handled fetch rejection for Firebase template:', event.reason.message);
    event.preventDefault(); // Prevent the error from being logged as unhandled
    return;
  }
  
  // Let other unhandled rejections through
  console.error('Unhandled promise rejection:', event.reason);
});

// Initialize theme early to prevent flash
function initThemeEarly() {
  const theme = localStorage.getItem('theme') || 'system';
  const html = document.documentElement;
  
  if (theme === 'dark') {
    html.classList.add('dark');
  } else if (theme === 'light') {
    html.classList.remove('dark');
  } else { // system
    const prefersDark = window.matchMedia('(prefers-color-scheme: dark)').matches;
    if (prefersDark) {
      html.classList.add('dark');
    } else {
      html.classList.remove('dark');
    }
  }
}

// Initialize font scale early to prevent layout shift
function initFontScaleEarly() {
  const savedScale = localStorage.getItem('fontScale');
  if (savedScale) {
    const scale = parseFloat(savedScale);
    if (scale >= 0.85 && scale <= 1.30) {
      document.documentElement.style.setProperty('--font-scale', String(scale));
    }
  }
}

// Initialize theme and font scale immediately
initThemeEarly();
initFontScaleEarly();

createRoot(document.getElementById("root")!).render(<App />);
