/**
 * ZIP Bundling Utility
 * Creates ZIP archives using JSZip
 */

import JSZip from 'jszip';

export interface ZipFile {
  name: string;
  content: Blob | string;
}

export async function createZip(files: ZipFile[], zipName: string): Promise<void> {
  const zip = new JSZip();
  
  // Add all files to zip
  for (const file of files) {
    if (file.content instanceof Blob) {
      const arrayBuffer = await file.content.arrayBuffer();
      zip.file(file.name, arrayBuffer);
    } else {
      zip.file(file.name, file.content);
    }
  }
  
  // Generate ZIP blob
  const zipBlob = await zip.generateAsync({ type: 'blob' });
  
  // Trigger download
  const url = URL.createObjectURL(zipBlob);
  const a = document.createElement('a');
  a.href = url;
  a.download = zipName;
  document.body.appendChild(a);
  a.click();
  document.body.removeChild(a);
  URL.revokeObjectURL(url);
}
