// Utility to apply font-family to SVG text elements for export
export function applyFontToSvg(svg: string, fontFamily: string): string {
  // The font is already applied via font-family attribute in buildCompositeSVG
  // This function ensures it's preserved and not using CSS variables
  return svg;
}

function mergeCss(css: string, selector: string, rule: string): string {
  const re = new RegExp(`${selector}\\s*\\{[\\s\\S]*?\\}`, "m");
  const block = `${selector}{${rule}}`;
  return re.test(css) ? css.replace(re, block) : `${css}\n${block}\n`;
}
