import type { StructuredTemplate } from "@shared/plan-types";

export const SWOT_TEMPLATE: StructuredTemplate = {
  key: "swot",
  name: "SWOT Analysis",
  description: "Strengths, Weaknesses, Opportunities, Threats.",
  fields: [
    { id: "strengths", label: "Strengths", type: "textarea", placeholder: "List your company's internal strengths..." },
    { id: "weaknesses", label: "Weaknesses", type: "textarea", placeholder: "List your company's internal weaknesses..." },
    { id: "opportunities", label: "Opportunities", type: "textarea", placeholder: "List external opportunities..." },
    { id: "threats", label: "Threats", type: "textarea", placeholder: "List external threats..." },
  ],
};

export const PERSONA_TEMPLATE: StructuredTemplate = {
  key: "persona",
  name: "Customer Persona",
  description: "Capture ICP/persona details.",
  fields: [
    { id: "name", label: "Persona Name", type: "text", placeholder: "e.g., Side-Hustle Sarah" },
    { id: "demographics", label: "Demographics", type: "textarea", placeholder: "Age, location, income, education..." },
    { id: "jobs", label: "Jobs-To-Be-Done / Goals", type: "textarea", placeholder: "What are they trying to accomplish?" },
    { id: "pain", label: "Pain Points", type: "textarea", placeholder: "What frustrates them or blocks their goals?" },
    { id: "channels", label: "Acquisition Channels", type: "textarea", placeholder: "Where do they discover new solutions?" },
  ],
};

export const STRUCTURED_TEMPLATES = [SWOT_TEMPLATE, PERSONA_TEMPLATE];

export function renderTemplateToMarkdown(key: string, data: Record<string, string>): string {
  if (key === "swot") {
    return `### SWOT Analysis

**Strengths**
${data.strengths || "-"}

**Weaknesses**
${data.weaknesses || "-"}

**Opportunities**
${data.opportunities || "-"}

**Threats**
${data.threats || "-"}`;
  }
  
  if (key === "persona") {
    return `### Customer Persona: ${data.name || "Unnamed"}

**Demographics**
${data.demographics || "-"}

**Goals / JTBD**
${data.jobs || "-"}

**Pain Points**
${data.pain || "-"}

**Acquisition Channels**
${data.channels || "-"}`;
  }
  
  return "";
}