import html2canvas from "html2canvas";

export async function captureElementToPng(el: HTMLElement, options?: { scale?: number }): Promise<string> {
  const canvas = await html2canvas(el, {
    backgroundColor: "#ffffff",
    scale: options?.scale ?? 2,
    useCORS: true,
    logging: false,
    windowWidth: el.scrollWidth,
    windowHeight: el.scrollHeight,
  });
  return canvas.toDataURL("image/png"); // data:image/png;base64,...
}

export async function copyDataUrlToClipboard(dataUrl: string): Promise<void> {
  try {
    // Convert data URL to blob
    const response = await fetch(dataUrl);
    const blob = await response.blob();
    
    // Copy to clipboard using modern Clipboard API
    if (navigator.clipboard && window.ClipboardItem) {
      await navigator.clipboard.write([
        new ClipboardItem({
          [blob.type]: blob
        })
      ]);
    } else {
      // Fallback for older browsers
      throw new Error("Clipboard API not supported");
    }
  } catch (error) {
    console.error("Failed to copy to clipboard:", error);
    throw error;
  }
}