import { ensureFontLoaded } from "./ensureFontLoaded";
import { applyFontToSvg } from "./svgInlineFont";

// Prepare SVG for export by ensuring fonts are loaded
export async function prepareSvgForExport(
  svgMarkup: string,
  fonts: string[]
): Promise<string> {
  // Ensure all fonts are loaded
  await Promise.all(fonts.map(font => ensureFontLoaded(font)));

  // Apply fonts to SVG (fonts are already applied in buildCompositeSVG)
  return applyFontToSvg(svgMarkup, fonts[0] || 'Inter');
}
