import { BrandPersonality, FontPair } from "@/types/brand";

// Web-safe Google alternatives to your licensed fonts
const PAIRS: Record<BrandPersonality, FontPair[]> = {
  Modern: [
    { heading: "Barlow Condensed", body: "Inter", note: "Sharp + clean" },
    { heading: "Montserrat", body: "Inter", note: "Geometric + neutral" },
  ],
  Natural: [
    { heading: "Barlow Condensed", body: "Source Sans 3", note: "Organic, friendly" },
    { heading: "Lora", body: "Inter", note: "Warm serif + clean body" },
  ],
  Luxury: [
    { heading: "Playfair Display", body: "Inter", note: "High-contrast elegance" },
    { heading: "Cormorant Garamond", body: "Inter", note: "Editorial luxe" },
  ],
  Friendly: [
    { heading: "Poppins", body: "Inter", note: "Rounded + approachable" },
    { heading: "Nunito", body: "Inter", note: "Soft and readable" },
  ],
};

export function pickFontPair(personality: BrandPersonality): FontPair {
  const options = PAIRS[personality];
  return options[Math.floor(Math.random() * options.length)];
}
