// Feature flags utility for environment-driven feature toggles
// Follows the existing environment variable pattern with VITE_ prefix

/**
 * Gets the feature flag state for the Slogan Generator
 * Defaults to true if environment variable is not set
 */
export function isSloganGeneratorEnabled(): boolean {
  const envValue = import.meta.env.VITE_SHOW_SLOGAN_GENERATOR;
  
  // Default to true if not set
  if (envValue === undefined || envValue === '') {
    return true;
  }
  
  // Handle string boolean values
  if (typeof envValue === 'string') {
    return envValue.toLowerCase() === 'true';
  }
  
  // Handle actual boolean values
  return Boolean(envValue);
}

/**
 * Gets the feature flag state for the Business Plan Developer
 * Defaults to true if environment variable is not set
 */
export function isBusinessPlanGeneratorEnabled(): boolean {
  const envValue = import.meta.env.VITE_SHOW_BUSINESS_PLAN;
  
  // Default to true if not set
  if (envValue === undefined || envValue === '') {
    return true;
  }
  
  // Handle string boolean values
  if (typeof envValue === 'string') {
    return envValue.toLowerCase() === 'true';
  }
  
  // Handle actual boolean values
  return Boolean(envValue);
}

/**
 * Feature flags configuration object
 * Can be extended for additional feature flags in the future
 */
export const featureFlags = {
  sloganGenerator: isSloganGeneratorEnabled(),
  businessPlan: isBusinessPlanGeneratorEnabled(),
} as const;