/**
 * WEBP Export Utility
 * Converts PNG to WEBP (modern compressed format)
 */

export async function pngToWebp(png: Blob): Promise<Blob> {
  return new Promise((resolve, reject) => {
    const canvas = document.createElement('canvas');
    const ctx = canvas.getContext('2d');
    
    if (!ctx) {
      reject(new Error('Failed to get canvas context'));
      return;
    }
    
    const img = new Image();
    const url = URL.createObjectURL(png);
    
    img.onload = () => {
      canvas.width = img.width;
      canvas.height = img.height;
      
      // Draw PNG
      ctx.drawImage(img, 0, 0);
      
      canvas.toBlob((blob) => {
        URL.revokeObjectURL(url);
        if (blob) {
          resolve(blob);
        } else {
          reject(new Error('Failed to create WEBP blob'));
        }
      }, 'image/webp', 0.92);
    };
    
    img.onerror = () => {
      URL.revokeObjectURL(url);
      reject(new Error('Failed to load PNG image'));
    };
    
    img.src = url;
  });
}
