/**
 * SVG Export Utility
 * Normalizes SVG for export: ensures viewBox, inlines styles, minifies
 */

export function normalizeSvg(svg: string): string {
  const parser = new DOMParser();
  const doc = parser.parseFromString(svg, 'image/svg+xml');
  const svgEl = doc.querySelector('svg');
  
  if (!svgEl) {
    throw new Error('Invalid SVG: no <svg> element found');
  }
  
  // Ensure viewBox is present
  if (!svgEl.hasAttribute('viewBox')) {
    const width = svgEl.getAttribute('width') || '500';
    const height = svgEl.getAttribute('height') || '500';
    svgEl.setAttribute('viewBox', `0 0 ${width} ${height}`);
  }
  
  // Ensure preserveAspectRatio
  if (!svgEl.hasAttribute('preserveAspectRatio')) {
    svgEl.setAttribute('preserveAspectRatio', 'xMidYMid meet');
  }
  
  // Remove width/height for better scaling
  svgEl.removeAttribute('width');
  svgEl.removeAttribute('height');
  
  // Serialize back to string
  const serializer = new XMLSerializer();
  let output = serializer.serializeToString(svgEl);
  
  // Basic minification: remove excessive whitespace
  output = output.replace(/>\s+</g, '><');
  
  return output;
}
