import type { BrandKit } from "@shared/brand-types";

export interface ExportStyleMap {
  h1Color: string; 
  h2Color: string; 
  h3Color: string; 
  bodyColor: string;
  hFont: string; 
  bFont: string;
  tableHeaderBg: string; 
  tableHeaderColor: string;
}

export function buildExportStyles(brand: BrandKit): ExportStyleMap {
  return {
    h1Color: brand.primary || "#111827",
    h2Color: brand.primary || "#111827",
    h3Color: brand.accent || brand.primary || "#111827",
    bodyColor: "#111827",
    hFont: brand.fontHead || "Inter, ui-sans-serif",
    bFont: brand.fontBody || "Inter, ui-sans-serif",
    tableHeaderBg: brand.primary || "#111827",
    tableHeaderColor: "#ffffff",
  };
}