// Utility to ensure a font is loaded before export
export async function ensureFontLoaded(fontFamily: string): Promise<void> {
  try {
    // Wait for any pending font loads
    if (document?.fonts?.ready) {
      await document.fonts.ready;
    }

    // Check if the font is already loaded
    if (document.fonts && document.fonts.check) {
      const isLoaded = document.fonts.check(`16px "${fontFamily}"`);
      if (isLoaded) {
        return;
      }
    }

    // Give it a moment to load
    await new Promise(resolve => setTimeout(resolve, 100));
  } catch (error) {
    // Soft-fail; exporters will use fallback if not loaded
    console.warn(`Font ${fontFamily} may not be fully loaded:`, error);
  }
}
