// src/lib/coverTint.ts
export function applyBrandTint(baseHex: string, overlayHex: string, alpha = 0.18) {
  const toRGB = (h: string) => {
    const n = parseInt(h.replace("#",""), 16);
    return { r: (n>>16)&255, g: (n>>8)&255, b: n&255 };
  };
  const toHex = (n: number) => (n | (1<<8)).toString(16).slice(1);
  try {
    const b = toRGB(baseHex), o = toRGB(overlayHex);
    const r = Math.round(b.r*(1-alpha) + o.r*alpha);
    const g = Math.round(b.g*(1-alpha) + o.g*alpha);
    const bl = Math.round(b.b*(1-alpha) + o.b*alpha);
    return `#${toHex(r)}${toHex(g)}${toHex(bl)}`;
  } catch { return baseHex; }
}