// src/lib/coverThemes.ts
export type CoverStyle = "Gradient" | "Minimal" | "Photo" | "Pattern";

export interface CoverTheme {
  id: string;
  name: string;
  style: CoverStyle;
  primary: string;
  secondary?: string;
  accent?: string;
  pattern?: "dots" | "grid" | "waves" | "none";
}

export const COVER_THEMES: CoverTheme[] = [
  { id: "aurora", name: "Aurora", style: "Gradient", primary: "#6D28D9", secondary: "#06B6D4", accent: "#F59E0B", pattern: "waves" },
  { id: "noir",   name: "Noir",   style: "Minimal",  primary: "#111827", secondary: "#374151", accent: "#10B981", pattern: "none"  },
  { id: "sunset", name: "Sunset", style: "Gradient", primary: "#EF4444", secondary: "#F59E0B", accent: "#FDE68A", pattern: "dots"  },
  { id: "paper",  name: "Paper",  style: "Pattern",  primary: "#2563EB", secondary: "#93C5FD", accent: "#F8FAFC", pattern: "grid"  },
];

export function getCoverThemeById(id: string): CoverTheme | undefined {
  return COVER_THEMES.find(theme => theme.id === id);
}

export function getDefaultCoverTheme(): CoverTheme {
  return COVER_THEMES[0]; // Aurora
}

export function getCoverThemesByStyle(style: CoverStyle): CoverTheme[] {
  return COVER_THEMES.filter(theme => theme.style === style);
}