import type { ToneOption } from "@shared/plan-types";

export const OUTLINE_SUGGEST_PROMPT = (
  company: string,
  industry: string,
  audience: string
) => `You are an expert business analyst. Propose a concise outline for a business plan for a company named "${company}" in the ${industry} industry targeting ${audience}. 
Include 8 top-level sections (executive summary, company overview, products/services, market analysis, marketing & sales, operations, organization & management, financials). 
For each, return 3-6 bullet points with short labels only. Output JSON with {sections:[{title, bullets:[...] }]}.`;

export const SECTION_DRAFT_PROMPT = (
  sectionTitle: string,
  company: string,
  description: string,
  tone: ToneOption
) => `Write a ${tone.toLowerCase()} draft for the section "${sectionTitle}" of a business plan for ${company}. 
Keep it 150-250 words, clear and skimmable, using markdown paragraphs and short lists when helpful.

Company description: ${description}

Focus on practical, actionable content that would be useful for investors or stakeholders reviewing this business plan.`;