import { useAuth } from '@/contexts/AuthContext';
import { getUserPaidStatus } from '@/services/authRedirect';

/**
 * Hook to get user's subscription plan status
 * Returns whether the user has a premium/paid subscription
 */
export function useUserPlan() {
  const { currentUser } = useAuth();
  const isPremium = getUserPaidStatus(currentUser?.email || undefined);
  
  return { isPremium };
}
