import { useEffect, useState } from 'react';
import lightLogo from '../assets/IBrandBiz Logo 2025.svg';
import darkLogo from '../assets/IBrandBiz Reverse 2025.svg';

export function useLogo() {
  const [isDark, setIsDark] = useState(false);

  useEffect(() => {
    // Check initial theme
    const checkTheme = () => {
      const theme = localStorage.getItem('theme') || 'system';
      let isDarkMode = false;
      
      if (theme === 'dark') {
        isDarkMode = true;
      } else if (theme === 'light') {
        isDarkMode = false;
      } else { // system
        isDarkMode = window.matchMedia('(prefers-color-scheme: dark)').matches;
      }
      
      setIsDark(isDarkMode || document.documentElement.classList.contains('dark'));
    };

    checkTheme();

    // Watch for theme changes
    const observer = new MutationObserver(checkTheme);
    observer.observe(document.documentElement, {
      attributes: true,
      attributeFilter: ['class']
    });

    // Watch for storage changes
    const handleStorageChange = (e: StorageEvent) => {
      if (e.key === 'theme') {
        checkTheme();
      }
    };
    window.addEventListener('storage', handleStorageChange);

    return () => {
      observer.disconnect();
      window.removeEventListener('storage', handleStorageChange);
    };
  }, []);

  return isDark ? darkLogo : lightLogo;
}