import { useQuery } from "@tanstack/react-query";

export interface IconEntitlement {
  licensed: boolean;
  requiresAttribution: boolean;
  canDownload: boolean;
  loading: boolean;
}

export function useIconEntitlement(iconId: string | null): IconEntitlement {
  const { data, isLoading } = useQuery({
    queryKey: ['/api/icons', iconId, 'entitlement'],
    queryFn: async () => {
      const response = await fetch(`/api/icons/${iconId}/entitlement`);
      if (!response.ok) {
        throw new Error('Failed to check icon entitlement');
      }
      return response.json();
    },
    enabled: !!iconId,
    staleTime: 5 * 60 * 1000, // Cache for 5 minutes
  });

  return {
    licensed: data?.licensed || false,
    requiresAttribution: data?.requiresAttribution || true,
    canDownload: data?.canDownload || true,
    loading: isLoading,
  };
}