import { useEffect, useState } from "react";

type Ent = {
  licensed: boolean;
  quotaRemaining: number;
  canDownloadOriginal: boolean;
};

export function useEntitlement(assetId: string | undefined) {
  const [state, setState] = useState<Ent & { loading: boolean; error?: string }>({
    licensed: false,
    quotaRemaining: 0,
    canDownloadOriginal: false,
    loading: true,
  });

  useEffect(() => {
    let cancel = false;
    if (!assetId) return;
    setState((s) => ({ ...s, loading: true }));
    fetch(`/api/stock/${assetId}/entitlement`)
      .then((r) => r.json())
      .then((data) => !cancel && setState({ ...data, loading: false }))
      .catch((e) => !cancel && setState((s) => ({ ...s, loading: false, error: String(e) })));
    return () => {
      cancel = true;
    };
  }, [assetId]);

  return state;
}