import {
  bulletCubeTeal,
  firstImpressionsImage,
  brandingImage,
  templatesImage,
  webDesignImage,
  mockupImage,
  stockImage,
  businessAssetsImage
} from "@/assets";

export interface HomeSlide {
  id: string;
  title: string;
  subtitle: string;
  cta?: {
    label: string;
    href: string;
  };
  imageUrl: string;
  enabled?: boolean;
}

export const homeSlides: HomeSlide[] = [
  {
    id: "first-impression",
    title: "Make Your First Impression Your Best...",
    subtitle: `<div class="space-y-2">
<div class="flex items-center"><img src="${bulletCubeTeal}" width="18" height="18" alt="" class="mr-3 flex-shrink-0" style="vertical-align: middle;">with a brand that stands out.</div>
<div class="flex items-center"><img src="${bulletCubeTeal}" width="18" height="18" alt="" class="mr-3 flex-shrink-0" style="vertical-align: middle;">with designs that inspire.</div>
</div>`,
    imageUrl: firstImpressionsImage,
    enabled: true
  },
  {
    id: "branding",
    title: "Build a Brand\nThat Stands Out",
    subtitle: "Contact us for all of your\nbranding needs.",
    cta: { label: "Explore Branding", href: "/services" },
    imageUrl: brandingImage,
    enabled: true
  },
  {
    id: "digital-assets",
    title: "Professional Brand Assets",
    subtitle: "Discover ready-made templates, mockups, and stock images designed to elevate your brand instantly.",
    cta: { label: "Explore Assets", href: "/business-assets/templates/business-plan" },
    imageUrl: businessAssetsImage,
    enabled: true
  },
  // PHASE 2 FEATURES - Hidden for Phase 1 release, keep code intact for future activation
  {
    id: "templates",
    title: "Professional Templates Ready to Use",
    subtitle: "Choose from hundreds of customizable templates to launch your brand online.",
    cta: { label: "See Templates", href: "/website-templates" },
    imageUrl: templatesImage,
    enabled: false
  },
  {
    id: "website",
    title: "Launch Your Website\nwith Ease",
    subtitle: "Secure your domain, pick a professional template, and launch your brand's home online.",
    cta: { label: "Launch Now", href: "/website-templates" },
    imageUrl: webDesignImage,
    enabled: false
  },
  {
    id: "mockups",
    title: "Showcase with\nStunning Mockups",
    subtitle: "We have various mockups for you to highlight your icons and designs for advertising.",
    cta: { label: "Browse Mockups", href: "/products" },
    imageUrl: mockupImage,
    enabled: false
  },
  {
    id: "stock",
    title: "Choose from Endless Stock Images",
    subtitle: "We have hundreds of stock images for you to choose from.",
    cta: { label: "Find Images", href: "/products" },
    imageUrl: stockImage,
    enabled: false
  }
];