import { useState } from "react";
import { ChevronDown } from "lucide-react";

export type QA = { q: string; a: JSX.Element | string; icon?: JSX.Element };

export default function Accordion({ items }: { items: QA[] }) {
  const [open, setOpen] = useState<number | null>(0);
  return (
    <div className="divide-y rounded-2xl border overflow-hidden">
      {items.map((it, i) => {
        const active = open === i;
        return (
          <div key={i} className="bg-white dark:bg-gray-800">
            <button
              className="w-full flex items-start gap-3 p-4 text-left hover:bg-gray-50 dark:hover:bg-gray-700"
              onClick={() => setOpen(active ? null : i)}
              aria-expanded={active}
            >
              <div className="mt-0.5">{it.icon}</div>
              <div className="flex-1">
                <div className="font-semibold">{it.q}</div>
              </div>
              <ChevronDown
                className={`w-5 h-5 transition-transform ${active ? "rotate-180" : ""}`}
              />
            </button>
            <div
              className={`px-4 pb-4 transition-[max-height] duration-300 ease-in-out ${
                active ? "max-h-[500px]" : "max-h-0 overflow-hidden"
              }`}
            >
              <div className="pl-9 text-sm text-gray-700 dark:text-gray-300">{it.a}</div>
            </div>
          </div>
        );
      })}
    </div>
  );
}