import { Monitor } from "lucide-react";
import { BrandTokens } from "./types";

interface Props {
  tokens: BrandTokens;
}

export default function HeaderMock({ tokens }: Props) {
  const { name, palette, iconUrl } = tokens;

  return (
    <div className="rounded-2xl border overflow-hidden">
      <div className="flex items-center gap-3 p-5 bg-white">
        <Monitor className="w-4 h-4 text-neutral-400" />
        <div className="text-sm font-medium">Website Header</div>
      </div>
      <div className="p-0">
        <div
          className="px-6 py-4 flex items-center justify-between"
          style={{ backgroundColor: palette.primary, color: palette.textLight }}
        >
          <div className="flex items-center gap-3">
            {iconUrl && <img src={iconUrl} alt="" className="w-7 h-7 object-contain" />}
            <span className="font-semibold">{name || "Brand"}</span>
          </div>
          <div className="flex gap-5 text-sm opacity-90">
            <span>Home</span>
            <span>Products</span>
            <span>Contact</span>
          </div>
        </div>
        <div className="p-6 bg-white text-sm text-neutral-600">
          Hero copy and CTA live here. Your brand colors and mark feel right at home.
        </div>
      </div>
    </div>
  );
}