import { CreditCard } from "lucide-react";
import { BrandTokens, LayoutOption } from "./types";

interface Props {
  tokens: BrandTokens;
  layout: LayoutOption;
}

export default function BusinessCardMock({ tokens, layout }: Props) {
  const { name, palette, fontFamily, textSize, iconUrl } = tokens;

  return (
    <div className="rounded-2xl border bg-white overflow-hidden">
      <div className="flex items-center gap-3 p-5" style={{ backgroundColor: palette.surface }}>
        <CreditCard className="w-4 h-4 text-neutral-400" />
        <div className="text-sm font-medium">Business Card</div>
      </div>
      <div className="p-6" style={{ background: `linear-gradient(180deg, ${palette.surface}, ${palette.neutral})` }}>
        <div className="rounded-xl border bg-white p-5 flex items-center justify-center">
          <div
            className={`flex ${layout === "side-by-side" ? "flex-row items-end gap-2" : "flex-col items-center gap-1"}`}
            style={{ fontFamily, lineHeight: 1.1 }}
          >
            {iconUrl && (
              <img
                src={iconUrl}
                alt="Logo"
                className="object-contain"
                style={{ width: 32, height: 32 }}
              />
            )}
            {name && (
              <span 
                style={{ 
                  fontSize: 14, 
                  fontWeight: 800, 
                  letterSpacing: "0.04em",
                  color: palette.textDark
                }}
              >
                {name}
              </span>
            )}
          </div>
        </div>
        <div className="mt-4 grid grid-cols-2 gap-2 text-xs text-neutral-500">
          <div>Email</div><div>hello@brand.com</div>
          <div>Phone</div><div>(555) 555-5555</div>
        </div>
      </div>
    </div>
  );
}