import { AppWindow } from "lucide-react";
import { BrandTokens } from "./types";

interface Props {
  tokens: BrandTokens;
}

export default function AppIconMock({ tokens }: Props) {
  const { name, palette, iconUrl } = tokens;

  return (
    <div className="rounded-2xl border bg-white overflow-hidden">
      <div className="flex items-center gap-3 p-5" style={{ backgroundColor: palette.surface }}>
        <AppWindow className="w-4 h-4 text-neutral-400" />
        <div className="text-sm font-medium">App Icon</div>
      </div>
      <div className="p-6 flex items-center justify-center">
        <div
          className="rounded-2xl shadow-inner flex items-center justify-center"
          style={{ width: 96, height: 96, backgroundColor: palette.accent }}
        >
          {iconUrl ? (
            <img src={iconUrl} alt="" className="w-12 h-12 object-contain" />
          ) : (
            <span className="text-white font-bold text-2xl">
              {name ? name.charAt(0).toUpperCase() : "A"}
            </span>
          )}
        </div>
      </div>
    </div>
  );
}