import { useEffect, useState, useMemo } from 'react';

// Check if Google Fonts are already loaded in index.html - no need to load again
function loadGoogleFonts() {
  // Fonts are already loaded in index.html, no need to load again
  return;
}

export const FONT_OPTIONS = [
  // Sans-Serif Fonts
  { label: 'Inter', sampleWeight: 700 },
  { label: 'Roboto', sampleWeight: 700 },
  { label: 'Open Sans', sampleWeight: 700 },
  { label: 'Lato', sampleWeight: 700 },
  { label: 'Montserrat', sampleWeight: 700 },
  { label: 'Poppins', sampleWeight: 600 },
  { label: 'Raleway', sampleWeight: 700 },
  { label: 'Nunito', sampleWeight: 700 },
  { label: 'Ubuntu', sampleWeight: 700 },
  { label: 'Outfit', sampleWeight: 700 },
  { label: 'Work Sans', sampleWeight: 600 },
  { label: 'Rubik', sampleWeight: 700 },
  { label: 'Barlow', sampleWeight: 600 },
  { label: 'Manrope', sampleWeight: 700 },
  { label: 'DM Sans', sampleWeight: 700 },
  { label: 'Quicksand', sampleWeight: 600 },
  { label: 'Karla', sampleWeight: 700 },
  { label: 'Mulish', sampleWeight: 700 },
  { label: 'Heebo', sampleWeight: 700 },
  { label: 'Titillium Web', sampleWeight: 700 },
  { label: 'Nunito Sans', sampleWeight: 700 },
  { label: 'Cabin', sampleWeight: 700 },
  { label: 'Hind', sampleWeight: 700 },
  { label: 'Josefin Sans', sampleWeight: 700 },
  { label: 'Exo', sampleWeight: 700 },
  { label: 'Comfortaa', sampleWeight: 700 },
  { label: 'Varela Round', sampleWeight: 400 },
  { label: 'Lexend', sampleWeight: 600 },
  { label: 'Figtree', sampleWeight: 700 },
  { label: 'Public Sans', sampleWeight: 700 },
  { label: 'Archivo', sampleWeight: 700 },
  { label: 'Jost', sampleWeight: 600 },
  { label: 'Oxygen', sampleWeight: 700 },
  { label: 'Red Hat Display', sampleWeight: 700 },
  { label: 'Alata', sampleWeight: 400 },
  { label: 'Arimo', sampleWeight: 700 },
  { label: 'Asap', sampleWeight: 700 },
  { label: 'Assistant', sampleWeight: 700 },
  { label: 'Catamaran', sampleWeight: 700 },
  { label: 'Dosis', sampleWeight: 700 },
  { label: 'Epilogue', sampleWeight: 700 },
  { label: 'Fira Sans', sampleWeight: 700 },
  { label: 'Hind Siliguri', sampleWeight: 700 },
  { label: 'IBM Plex Sans', sampleWeight: 600 },
  { label: 'Inconsolata', sampleWeight: 700 },
  { label: 'Kanit', sampleWeight: 600 },
  { label: 'Lora', sampleWeight: 700 },
  { label: 'Mukta', sampleWeight: 700 },
  { label: 'Noto Sans', sampleWeight: 700 },
  { label: 'Onest', sampleWeight: 700 },
  { label: 'Plus Jakarta Sans', sampleWeight: 700 },
  { label: 'Prompt', sampleWeight: 600 },
  { label: 'PT Sans', sampleWeight: 700 },
  { label: 'Questrial', sampleWeight: 400 },
  { label: 'Readex Pro', sampleWeight: 600 },
  { label: 'Saira', sampleWeight: 700 },
  { label: 'Signika', sampleWeight: 700 },
  { label: 'Space Grotesk', sampleWeight: 700 },
  { label: 'Spartan', sampleWeight: 700 },
  
  // Serif Fonts
  { label: 'Playfair Display', sampleWeight: 700 },
  { label: 'Merriweather', sampleWeight: 700 },
  { label: 'Libre Baskerville', sampleWeight: 700 },
  { label: 'Crimson Text', sampleWeight: 700 },
  { label: 'PT Serif', sampleWeight: 700 },
  { label: 'Bitter', sampleWeight: 700 },
  { label: 'Vollkorn', sampleWeight: 700 },
  { label: 'Cormorant Garamond', sampleWeight: 700 },
  { label: 'Cinzel', sampleWeight: 700 },
  { label: 'EB Garamond', sampleWeight: 700 },
  { label: 'Libre Franklin', sampleWeight: 700 },
  { label: 'Arvo', sampleWeight: 700 },
  { label: 'Cardo', sampleWeight: 700 },
  { label: 'Domine', sampleWeight: 700 },
  { label: 'Zilla Slab', sampleWeight: 700 },
  { label: 'Spectral', sampleWeight: 700 },
  { label: 'Crimson Pro', sampleWeight: 700 },
  { label: 'Calistoga', sampleWeight: 400 },
  { label: 'Rokkitt', sampleWeight: 700 },
  { label: 'Gelasio', sampleWeight: 700 },
  
  // Display & Decorative Fonts
  { label: 'Bebas Neue', sampleWeight: 400 },
  { label: 'Righteous', sampleWeight: 400 },
  { label: 'Anton', sampleWeight: 400 },
  { label: 'Pacifico', sampleWeight: 400 },
  { label: 'Lobster', sampleWeight: 400 },
  { label: 'Permanent Marker', sampleWeight: 400 },
  { label: 'Bungee', sampleWeight: 400 },
  { label: 'Russo One', sampleWeight: 400 },
  { label: 'Abril Fatface', sampleWeight: 400 },
  { label: 'Alfa Slab One', sampleWeight: 400 },
  { label: 'Archivo Black', sampleWeight: 400 },
  { label: 'Bangers', sampleWeight: 400 },
  { label: 'Monoton', sampleWeight: 400 },
  { label: 'Fjalla One', sampleWeight: 400 },
  { label: 'Fugaz One', sampleWeight: 400 },
  { label: 'Kaushan Script', sampleWeight: 400 },
  { label: 'Orbitron', sampleWeight: 700 },
  { label: 'Patua One', sampleWeight: 400 },
  { label: 'Racing Sans One', sampleWeight: 400 },
  { label: 'Saira Condensed', sampleWeight: 700 },
  { label: 'Shadows Into Light', sampleWeight: 400 },
  { label: 'Teko', sampleWeight: 700 },
  { label: 'Yellowtail', sampleWeight: 400 },
  { label: 'Yeseva One', sampleWeight: 400 },
  { label: 'Caveat', sampleWeight: 700 },
  { label: 'Dancing Script', sampleWeight: 700 },
  { label: 'Great Vibes', sampleWeight: 400 },
  { label: 'Sacramento', sampleWeight: 400 },
  { label: 'Amatic SC', sampleWeight: 700 },
  { label: 'Satisfy', sampleWeight: 400 },
  { label: 'Cookie', sampleWeight: 400 },
  { label: 'Courgette', sampleWeight: 400 },
  { label: 'Indie Flower', sampleWeight: 400 },
  { label: 'Fredoka', sampleWeight: 600 },
  { label: 'Acme', sampleWeight: 400 },
  { label: 'Bowlby One SC', sampleWeight: 400 },
  { label: 'Carter One', sampleWeight: 400 },
];

export function FontPicker({
  value,
  onChange,
  sampleText = 'Sample Text',
}: {
  value?: string;
  onChange: (font: string) => void;
  sampleText?: string;
}) {
  useEffect(() => loadGoogleFonts(), []);
  const [query, setQuery] = useState("");

  const filtered = useMemo(() => {
    const q = query.trim().toLowerCase();
    return q
      ? FONT_OPTIONS.filter((f) => f.label.toLowerCase().includes(q))
      : FONT_OPTIONS;
  }, [query]);

  return (
    <div className="border border-gray-200 rounded-lg bg-white">
      {/* Search Header */}
      <div className="p-3 border-b border-gray-200">
        <input
          type="text"
          placeholder="Search fonts..."
          className="w-full h-9 rounded-md border border-gray-300 px-3 text-sm outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500"
          value={query}
          onChange={(e) => setQuery(e.target.value)}
        />
      </div>

      {/* Info Line */}
      <div className="text-[11px] text-gray-500 px-3 py-2 border-b border-gray-200">
        Showing {filtered.length} of {FONT_OPTIONS.length} fonts (Professional Collection)
      </div>

      {/* Scrollable Grid */}
      <div className="max-h-64 overflow-y-auto p-2">
        <div className="grid grid-cols-3 gap-2">
          {filtered.map((f) => (
            <button
              key={f.label}
              onClick={() => onChange(f.label)}
              className={`border rounded-lg text-center p-3 hover:bg-gray-50 transition ${
                value === f.label ? 'border-blue-500 ring-2 ring-blue-500 bg-blue-50' : 'border-gray-300'
              }`}
              data-testid={`font-option-${f.label.toLowerCase().replace(/\s+/g, '-')}`}
            >
              <div className="text-[10px] text-gray-500 mb-2">{f.label}</div>
              <div
                style={{
                  fontFamily: `'${f.label}', system-ui, sans-serif`,
                  fontWeight: f.sampleWeight as any,
                }}
                className="text-lg leading-tight"
              >
                {sampleText}
              </div>
            </button>
          ))}
        </div>
      </div>

      {/* Tip */}
      <div className="text-[10px] text-gray-400 px-3 py-2 border-t border-gray-200">
        Tip: This list uses Google Fonts. Make sure the families are included in your page's link tags so they render correctly.
      </div>
    </div>
  );
}
