// src/components/brand/PalettePicker.tsx
import React from 'react';
import { PALETTES } from './palettes';

export function PalettePicker({
  value,
  onChange,
  size = 18,
}: {
  value: number;
  onChange: (index: number) => void;
  size?: number;
}) {
  return (
    <div className="flex flex-wrap gap-2">
      {PALETTES.map((p, i) => (
        <button
          key={p.name}
          aria-label={p.name}
          title={p.name}
          onClick={() => onChange(i)}
          className={`rounded-full border transition-transform focus:outline-none ${value === i ? 'ring-2 ring-offset-2 ring-primary' : 'border-border hover:scale-105'}`}
          style={{
            width: size + 6,
            height: size + 6,
            background: `linear-gradient(135deg, ${p.bg} 60%, ${p.fg} 60%)`,
          }}
        />
      ))}
    </div>
  );
}