// src/components/brand/LogoPreview.tsx
import React, { useEffect } from 'react';
import { PALETTES } from './palettes';

const FONTS = [
  { family: 'Poppins', weight: 600 },
  { family: 'Montserrat', weight: 700 },
  { family: 'Playfair Display', weight: 600 },
  { family: 'Inter', weight: 800 },
  { family: 'Outfit', weight: 700 },
  { family: 'Raleway', weight: 700 },
  { family: 'Rubik', weight: 700 },
];

function loadGoogleFonts() {
  const existed = document.getElementById('ibrandbiz-google-fonts');
  if (existed) return;
  const link = document.createElement('link');
  link.id = 'ibrandbiz-google-fonts';
  link.rel = 'stylesheet';
  link.href =
    'https://fonts.googleapis.com/css2?family=Inter:wght@600;700;800&family=Montserrat:wght@700&family=Outfit:wght@700&family=Poppins:wght@600&family=Playfair+Display:wght@600&family=Raleway:wght@700&family=Rubik:wght@700&display=swap';
  document.head.appendChild(link);
}

export function LogoPreview({
  name,
  paletteIndex = 0,
  fontFamily,
}: {
  name: string;
  paletteIndex?: number;
  fontFamily?: string; // optional, still cycles fonts by default
}) {
  useEffect(() => loadGoogleFonts(), []);
  const pal = PALETTES[paletteIndex % PALETTES.length];

  const fonts = fontFamily
    ? [{ family: fontFamily, weight: 700 }]
    : FONTS.slice(0, 4); // keep multiple previews when no font chosen

  return (
    <div className="grid grid-cols-2 gap-3">
      {fonts.map((font, i) => (
        <div
          key={`${font.family}-${i}`}
          className="rounded-lg p-5 flex items-center justify-center"
          style={{ backgroundColor: pal.bg }}
        >
          <span
            style={{
              fontFamily: `'${font.family}', system-ui, sans-serif`,
              fontWeight: font.weight as any,
              color: pal.fg,
              letterSpacing: '0.3px',
              fontSize: '1.25rem',
            }}
          >
            {name}
          </span>
        </div>
      ))}
    </div>
  );
}