import { useEffect } from 'react';

// Check if Google Fonts are already loaded in index.html - no need to load again
function loadGoogleFonts() {
  // Fonts are already loaded in index.html, no need to load again
  return;
}

export const FONT_OPTIONS = [
  { label: 'Outfit', sampleWeight: 700 },
  { label: 'Inter', sampleWeight: 800 },
  { label: 'Poppins', sampleWeight: 600 },
  { label: 'Montserrat', sampleWeight: 700 },
  { label: 'Rubik', sampleWeight: 700 },
  { label: 'Raleway', sampleWeight: 700 },
  { label: 'Playfair Display', sampleWeight: 600 }, // serif
];

export function FontPicker({
  value,
  onChange,
  sampleText = 'Your Brand Name',
}: {
  value?: string;
  onChange: (font: string) => void;
  sampleText?: string;
}) {
  useEffect(() => loadGoogleFonts(), []);

  return (
    <div className="grid grid-cols-1 sm:grid-cols-2 gap-2">
      {FONT_OPTIONS.map((f) => (
        <button
          key={f.label}
          onClick={() => onChange(f.label)}
          className={`border rounded-lg text-left p-3 hover:bg-muted transition ${
            value === f.label ? 'border-primary ring-1 ring-primary' : 'border-border'
          }`}
          data-testid={`font-option-${f.label.toLowerCase().replace(/\s+/g, '-')}`}
        >
          <div className="text-xs text-muted-foreground mb-1">{f.label}</div>
          <div
            style={{
              fontFamily: `'${f.label}', system-ui, sans-serif`,
              fontWeight: f.sampleWeight as any,
            }}
            className="text-lg truncate"
          >
            {sampleText}
          </div>
        </button>
      ))}
    </div>
  );
}