import React from 'react';
import { Settings } from 'lucide-react';
import { useLocation } from 'wouter';
import { NotificationsBell } from './NotificationsBell';
import { CartDrawer } from './CartDrawer';

interface TopBarProps {
  title: string;
}

export function TopBar({ title }: TopBarProps) {
  const [, setLocation] = useLocation();

  return (
    <header className="bg-card border-b border-border px-6 py-4">
      <div className="flex items-center justify-between">
        <h1 className="text-2xl font-bold text-foreground" data-testid="text-page-title">{title}</h1>
        <div className="flex items-center gap-2">
          <NotificationsBell />
          <CartDrawer />
          <button 
            onClick={() => setLocation('/settings')}
            className="p-2 text-muted-foreground hover:text-foreground rounded-lg hover:bg-muted transition-colors"
            data-testid="button-settings"
            title="Settings"
          >
            <Settings className="h-4 w-4" />
          </button>
        </div>
      </div>
    </header>
  );
}
