
import Footer from "@/components/Footer";
import HeaderNav from "@/components/HeaderNav";

interface TemplatePageProps {
  children: React.ReactNode;
  bannerTitle?: string;
  bannerSubtitle?: string;
  bannerImage?: string;
  flipImage?: boolean;
}

export default function TemplatePage({ 
  children, 
  bannerTitle, 
  bannerSubtitle,
  bannerImage,
  flipImage 
}: TemplatePageProps) {
  return (
    <div className="min-h-screen bg-background">
      {/* Header Navigation */}
      <HeaderNav />
      
      {/* Banner Section - Only show if bannerTitle OR bannerImage is provided */}
      {(bannerTitle || bannerImage) && (
        <section className="hero-slider relative overflow-hidden mt-6 mx-auto" style={{ width: '100%', maxWidth: '2048px', aspectRatio: '2048 / 632' }}>
          {bannerImage ? (
            /* Actual Image Background */
            <div className="absolute inset-0">
              <img 
                src={bannerImage}
                alt="Banner"
                className={`w-full h-full object-cover ${flipImage ? 'transform scale-x-[-1]' : ''}`}
              />
            </div>
          ) : (
            /* Default Gradient Background */
            <div className="absolute inset-0">
              <div className="w-full h-full bg-gradient-to-br from-slate-100 via-slate-200 to-slate-300 dark:from-slate-700 dark:via-slate-800 dark:to-slate-900" />
            </div>
          )}

          {/* Left-weighted Gradient Overlay */}
          <div className="absolute inset-0 bg-gradient-to-r from-black/40 via-black/20 to-transparent pointer-events-none" />

          {/* Content Overlay */}
          <div className="absolute inset-0 flex items-center justify-start z-30">
            <div className="text-left max-w-xl pl-6 md:pl-16 lg:pl-20 pr-4 md:pr-8">
              <h1 className="text-xl md:text-3xl lg:text-4xl font-bold text-white mb-2 drop-shadow-lg">
                {bannerTitle}
              </h1>
              {bannerSubtitle && (
                <p className="text-xs md:text-sm lg:text-base text-white mb-4 drop-shadow-lg max-w-lg">
                  {bannerSubtitle}
                </p>
              )}
            </div>
          </div>
        </section>
      )}
      
      {/* Unique Content Area */}
      <main>
        {children}
      </main>
      
      {/* Footer */}
      <Footer />
    </div>
  );
}