import { useEffect, useRef } from "react";
import { useLocation } from "wouter";
import { tlog } from "@/utils/telemetry";

export default function Redirect({ to, from }: { to: string; from?: string }) {
  const [location, navigate] = useLocation();
  const logged = useRef(false);
  
  useEffect(() => {
    // Log redirect telemetry once (capture pre-navigation location)
    if (!logged.current) {
      const fromPath = from || location;
      tlog({ t: "redirect", from: fromPath, path: to });
      logged.current = true;
    }
    
    navigate(to, { replace: true });
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [to, navigate]); // Don't depend on location to avoid duplicate logs
  
  return null;
}
