import {
  Dialog,
  DialogContent,
  DialogDescription,
  DialogFooter,
  DialogHeader,
  DialogTitle,
} from "@/components/ui/dialog";
import { Button } from "@/components/ui/button";
import { Crown } from "lucide-react";
import { useLocation } from "wouter";

interface PaywallModalProps {
  isOpen: boolean;
  onClose: () => void;
  feature?: string;
  description?: string;
}

export function PaywallModal({ 
  isOpen, 
  onClose, 
  feature = "advanced features",
  description = "Unlock more options and premium tools"
}: PaywallModalProps) {
  const [, navigate] = useLocation();
  
  const handleUpgrade = () => {
    navigate("/pricing");
  };
  
  const handleMaybeLater = () => {
    // Store timestamp for 24-hour suppression
    localStorage.setItem("paywallDismissedAt", String(Date.now()));
    onClose();
  };

  return (
    <Dialog open={isOpen} onOpenChange={onClose}>
      <DialogContent className="sm:max-w-[425px]" data-testid="paywall-modal">
        <DialogHeader>
          <div className="flex items-center gap-2">
            <Crown className="h-6 w-6 text-yellow-500" />
            <DialogTitle data-testid="paywall-title">
              Upgrade to Premium
            </DialogTitle>
          </div>
          <DialogDescription data-testid="paywall-description">
            {description}. Get access to {feature} with a premium subscription.
          </DialogDescription>
        </DialogHeader>
        
        <div className="py-4">
          <div className="space-y-4">
            <div className="bg-gradient-to-r from-primary/10 to-accent/10 rounded-lg p-4">
              <h4 className="font-semibold text-lg mb-2">Premium Benefits</h4>
              <ul className="space-y-2 text-sm text-muted-foreground">
                <li className="flex items-center gap-2">
                  <span className="w-1.5 h-1.5 bg-primary rounded-full"></span>
                  Up to 8 AI-generated options instead of 1
                </li>
                <li className="flex items-center gap-2">
                  <span className="w-1.5 h-1.5 bg-primary rounded-full"></span>
                  Advanced tone and style options
                </li>
                <li className="flex items-center gap-2">
                  <span className="w-1.5 h-1.5 bg-primary rounded-full"></span>
                  Export to PDF, DOCX, and Google Docs
                </li>
                <li className="flex items-center gap-2">
                  <span className="w-1.5 h-1.5 bg-primary rounded-full"></span>
                  Save and organize your creations
                </li>
                <li className="flex items-center gap-2">
                  <span className="w-1.5 h-1.5 bg-primary rounded-full"></span>
                  Priority support and early access features
                </li>
              </ul>
            </div>
          </div>
        </div>
        
        <DialogFooter className="flex gap-3">
          <Button
            variant="outline"
            onClick={handleMaybeLater}
            data-testid="button-paywall-close"
          >
            Maybe Later
          </Button>
          <Button
            onClick={handleUpgrade}
            className="flex-1 bg-gradient-to-r from-primary to-accent hover:from-primary/90 hover:to-accent/90"
            data-testid="button-paywall-upgrade"
          >
            <Crown className="w-4 h-4 mr-2" />
            Upgrade to Premium
          </Button>
        </DialogFooter>
      </DialogContent>
    </Dialog>
  );
}