import { Link } from "wouter";
import { Linkedin, Mail, Phone, MapPin, Twitter, Instagram, Facebook } from "lucide-react";
import reverseLogo from "@/assets/IBrandBiz Reverse 2025.svg";

export default function Footer() {
  const currentYear = new Date().getFullYear();

  const navigationLinks = [
    { label: "Home", href: "/" },
    { label: "About Us", href: "/about" },
    { label: "Services", href: "/services" },
    { label: "Products", href: "/products" },
    { label: "Pricing", href: "/pricing/business-development" },
    { label: "Resources", href: "/resources" },
    { label: "FAQ", href: "/faq" },
    { label: "Terms", href: "/terms" },
    { label: "Privacy", href: "/privacy" },
    { label: "Cookies", href: "/cookie-policy" },
  ];

  const socialLinks = [
    { name: "LinkedIn", href: "https://www.linkedin.com/company/ibrandbiz/about/?viewAsMember=true", icon: <Linkedin className="h-5 w-5" /> },
    { name: "X", href: "#", icon: <Twitter className="h-5 w-5" /> },
    { name: "Instagram", href: "#", icon: <Instagram className="h-5 w-5" /> },
    { name: "Facebook", href: "#", icon: <Facebook className="h-5 w-5" /> },
  ];

  const contactInfo = [
    { icon: <Mail className="h-4 w-4" />, text: "info@ibrandbiz.com", href: "mailto:info@ibrandbiz.com" },
    { icon: <Phone className="h-4 w-4" />, text: "+1 (346) 530-8908", href: "tel:+13465308908" },
    { icon: <MapPin className="h-4 w-4" />, text: "Miami, FL", href: "#" },
  ];

  return (
    <footer className="bg-gray-900 dark:bg-black text-white">
      <div className="mx-auto max-w-7xl px-1 sm:px-1 lg:px-5 pt-8 pb-4">
        {/* Main footer content */}
        {/* Grid = 5 columns on lg: Brand | Navigation | Services | Products | Contact */}
        <div className="grid items-start gap-y-10 gap-x-16 md:grid-cols-2 lg:grid-cols-[1.3fr_1fr_1fr_1fr_1fr]">
          {/* Brand */}
          <div>
            <Link href="/">
              <div className="mb-4 flex cursor-pointer items-center" data-testid="link-footer-logo">
                <img src={reverseLogo} alt="IBrandBiz Logo" className="h-12 w-auto" />
              </div>
            </Link>
            <p className="text-xs text-gray-300 mb-6 max-w-sm">
              Your one-stop solution for building memorable brands. From business names to complete
              brand kits, we help entrepreneurs succeed.
            </p>
            <div className="flex space-x-4">
              {socialLinks.map((s) => (
                <a
                  key={s.name}
                  href={s.href}
                  target="_blank"
                  rel="noopener noreferrer"
                  className="rounded-full bg-gray-800 p-3 transition-colors duration-300 hover:bg-primary"
                  data-testid={`link-social-${s.name.toLowerCase()}`}
                  aria-label={`Follow us on ${s.name}`}
                >
                  {s.icon}
                </a>
              ))}
            </div>
          </div>

          {/* Navigation (two tight inner columns, treated as ONE section) */}
          <div className="mr-8">
            <h3 className="mb-4 text-xs font-semibold text-center" data-testid="title-footer-navigation">
              Navigation
            </h3>
            <div className="grid grid-cols-2 gap-x-8 gap-y-1">
              <ul className="space-y-0.5">
                {navigationLinks.slice(0, 5).map((link) => (
                  <li key={link.href}>
                    <Link href={link.href}>
                      <span
                        className="cursor-pointer text-xs text-gray-300 transition-colors duration-300 hover:text-white"
                        data-testid={`link-footer-${link.label.toLowerCase().replace(/\s+/g, "-")}`}
                      >
                        {link.label}
                      </span>
                    </Link>
                  </li>
                ))}
              </ul>
              <ul className="space-y-0.5">
                {navigationLinks.slice(5, 10).map((link) => (
                  <li key={link.href}>
                    <Link href={link.href}>
                      <span
                        className="cursor-pointer text-xs text-gray-300 transition-colors duration-300 hover:text-white"
                        data-testid={`link-footer-${link.label.toLowerCase().replace(/\s+/g, "-")}`}
                      >
                        {link.label}
                      </span>
                    </Link>
                  </li>
                ))}
              </ul>
            </div>
          </div>

          {/* Services */}
          <div>
            <h3 className="mb-4 text-xs font-semibold" data-testid="title-footer-services">
              Services
            </h3>
            <ul className="space-y-0.5">
              <li>
                <Link href="/business-development/brand-name-wizard">
                  <span className="cursor-pointer text-xs text-gray-300 transition-colors duration-300 hover:text-white" data-testid="link-footer-business-names">
                    Business Names
                  </span>
                </Link>
              </li>
              <li>
                <Link href="/business-development/slogan-generator">
                  <span className="cursor-pointer text-xs text-gray-300 transition-colors duration-300 hover:text-white" data-testid="link-footer-slogan">
                    Slogan Generator
                  </span>
                </Link>
              </li>
              <li>
                <Link href="/web-services/domains">
                  <span className="cursor-pointer text-xs text-gray-300 transition-colors duration-300 hover:text-white" data-testid="link-footer-domains">
                    Domain Search
                  </span>
                </Link>
              </li>
            </ul>
          </div>

          {/* Products */}
          <div className="-ml-6">
            <h3 className="mb-4 text-xs font-semibold" data-testid="title-footer-products">
              Products
            </h3>
            <ul className="space-y-0.5">
              <li>
                <Link href="/business-development/brand-kit">
                  <span className="cursor-pointer text-xs text-gray-300 transition-colors duration-300 hover:text-white" data-testid="link-footer-brand-kits">
                    Brand Kits
                  </span>
                </Link>
              </li>
              <li>
                <Link href="/business-development/ai-business-plan-developer">
                  <span className="cursor-pointer text-xs text-gray-300 transition-colors duration-300 hover:text-white" data-testid="link-footer-business-plan">
                    Business Plan Developer
                  </span>
                </Link>
              </li>
            </ul>
          </div>

          {/* Contact */}
          <div>
            <h3 className="mb-4 text-xs font-semibold" data-testid="title-footer-contact">
              Contact
            </h3>
            <ul className="space-y-1">
              {contactInfo.map((c, i) => (
                <li key={i}>
                  <a
                    href={c.href}
                    className="flex items-center space-x-3 text-xs text-gray-300 transition-colors duration-300 hover:text-white"
                    data-testid={`link-footer-contact-${i}`}
                  >
                    {c.icon}
                    <span>{c.text}</span>
                  </a>
                </li>
              ))}
            </ul>
          </div>
        </div>

        {/* Bottom bar */}
        <div className="mt-6 flex flex-col items-center justify-between gap-4 border-t border-white/10 pt-4 md:flex-row">
          <p className="text-xs text-gray-400" data-testid="text-footer-copyright">
            © {currentYear} IBrandBiz. All rights reserved.
          </p>
          <div className="flex space-x-6">
            <Link href="/terms">
              <span className="cursor-pointer text-xs text-gray-400 transition-colors duration-300 hover:text-white" data-testid="link-footer-terms-bottom">
                Terms of Service
              </span>
            </Link>
            <Link href="/privacy">
              <span className="cursor-pointer text-xs text-gray-400 transition-colors duration-300 hover:text-white" data-testid="link-footer-privacy-bottom">
                Privacy Policy
              </span>
            </Link>
          </div>
        </div>
      </div>
    </footer>
  );
}