import React from 'react';
import { Sidebar } from './Sidebar';
import { TopBar } from './TopBar';
import Footer from './Footer';

interface DashboardTemplatePageProps {
  title: string;
  children: React.ReactNode;
}

export function DashboardTemplatePage({ title, children }: DashboardTemplatePageProps) {
  return (
    <div className="min-h-screen bg-background flex flex-col">
      <div className="flex flex-1 min-h-0 items-stretch">
        <Sidebar />
        <div className="flex-1 min-w-0">
          <TopBar title={title} />
          <main className="p-4 md:p-6">
            {children}
          </main>
        </div>
      </div>
      <Footer />
    </div>
  );
}