import React from "react";
import type { PaletteKey } from "../services/brand/palette";

type Props = {
  label: string;
  hex: string;
  onChange?: (v: string) => void;
  onRoll?: () => void;
  locked?: boolean;
  onToggleLock?: () => void;
};

export const ColorSwatch: React.FC<Props> = ({
  label, hex, onChange, onRoll, locked, onToggleLock
}) => {
  return (
    <div className="rounded-xl border bg-white shadow-sm overflow-hidden">
      <div className="h-16" style={{ background: hex }} />
      <div className="p-3 flex items-center justify-between gap-2">
        <div className="text-sm font-medium text-neutral-700">{label}</div>
        <div className="flex items-center gap-2">
          <input
            value={hex}
            onChange={(e) => onChange?.(e.target.value)}
            className="w-28 text-xs px-2 py-1 rounded-md border"
          />
          <button onClick={onRoll} className="text-xs px-2 py-1 rounded-md border hover:bg-neutral-50">🎲</button>
          <button onClick={onToggleLock} className="text-xs px-2 py-1 rounded-md border hover:bg-neutral-50">{locked ? "🔒" : "🔓"}</button>
        </div>
      </div>
    </div>
  );
};