import { useRef } from "react";
import { captureElementToPng } from "@/lib/snapshot";
import { usePlanStoreV2 } from "@/stores/usePlanStore.v2";

export function ChartSnapshotButton({
  targetSectionId,
  getElement,
  title = "Chart Snapshot",
}: {
  targetSectionId: string;
  getElement: () => HTMLElement | null;
  title?: string;
}) {
  const update = usePlanStoreV2((s) => s.updateSection);
  const busy = useRef(false);

  async function snap() {
    if (busy.current) return;
    busy.current = true;
    try {
      const el = getElement();
      if (!el) return;
      const dataUrl = await captureElementToPng(el, { scale: 2 });
      const md = `### ${title}

![${title}](${dataUrl})`;
      update(targetSectionId, (prev: any) => ({
        content: `${prev?.content ? prev.content + "\n\n" : ""}${md}`,
      }));
    } finally {
      busy.current = false;
    }
  }

  return (
    <button
      className="rounded-md border px-2 py-1 text-sm hover:bg-gray-50"
      onClick={snap}
      data-testid="button-snapshot"
    >
      Insert Snapshot (PNG)
    </button>
  );
}