import { AlertCircle, Copy } from "lucide-react";
import { Button } from "@/components/ui/button";
import { useToast } from "@/hooks/use-toast";

interface AttributionNoticeProps {
  text: string;
  html: string;
  copyText?: string;
}

export default function AttributionNotice({ text, html, copyText }: AttributionNoticeProps) {
  const { toast } = useToast();

  const copyAttribution = async () => {
    try {
      await navigator.clipboard.writeText(copyText || text);
      toast({
        title: "Attribution copied!",
        description: "Attribution text has been copied to your clipboard.",
      });
    } catch (error) {
      toast({
        title: "Copy failed",
        description: "Failed to copy attribution text.",
        variant: "destructive",
      });
    }
  };

  return (
    <div className="bg-gray-50 dark:bg-gray-950/20 border border-gray-200 dark:border-gray-800 rounded-lg p-3">
      <div className="flex items-start gap-2">
        <AlertCircle className="h-4 w-4 text-gray-600 dark:text-gray-400 mt-0.5 flex-shrink-0" />
        <div className="flex-1 min-w-0">
          <p className="text-sm text-gray-800 dark:text-gray-200 mb-2">
            <strong>Attribution Required:</strong> Please include the following credit where this icon appears:
          </p>
          <div className="bg-white dark:bg-gray-800 rounded border p-2 text-xs font-mono break-all">
            {text}
          </div>
          <div className="mt-2 flex gap-2">
            <Button
              size="sm"
              variant="outline"
              onClick={copyAttribution}
              className="text-xs h-7"
            >
              <Copy className="h-3 w-3 mr-1" />
              Copy Attribution
            </Button>
            <a
              href="https://ibrandbiz.com/pricing"
              target="_blank"
              rel="noopener noreferrer"
              className="text-xs text-gray-700 dark:text-gray-300 underline hover:no-underline"
            >
              Upgrade to Pro to remove attribution →
            </a>
          </div>
        </div>
      </div>
    </div>
  );
}