import { z } from "zod";

export const BPItemSchema = z.object({
  id: z.string(),             // e.g., barber-shop
  name: z.string(),           // display name
  category: z.string().optional(),
  tags: z.array(z.string()).optional(),
  previewUrl: z.string(),     // /templates/business-plan/previews/*.jpg|png (cover/main preview)
  previewPages: z.array(z.string()).optional(), // Array of all page previews for multi-page preview
  docxUrl: z.string(),        // /templates/business-plan/docs/*.docx
  updatedAt: z.string().optional(),
  sections: z.array(z.string()).optional(), // optional listing for the card
});

export const BPManifestSchema = z.object({
  collection: z.literal("business-plan"),
  version: z.number(),
  items: z.array(BPItemSchema),
});

export type BPManifest = z.infer<typeof BPManifestSchema>;
export type BPItem = z.infer<typeof BPItemSchema>;