// SPA 404 Runtime Monitor
// Listens for client-side 404 events and logs them for debugging/analytics

// Attach listener once at app bootstrap
if (typeof window !== 'undefined' && !window.__spa404Bound) {
  window.__spa404Bound = true;
  
  window.addEventListener('spa-404', (e: any) => {
    const path = e?.detail || window.location.pathname;
    console.warn('[404-event]', path);
    
    // Send to telemetry endpoint for analytics tracking
    fetch('/api/telemetry', {
      method: 'POST',
      headers: { 'Content-Type': 'application/json' },
      body: JSON.stringify({ 
        t: 'spa-404', 
        path, 
        ts: Date.now() 
      })
    }).catch(() => {
      // Silent fail - don't break app if telemetry is down
    });
  });
  
  console.debug('[spa404-listener] Runtime 404 monitor initialized');
}

// TypeScript declaration for the global flag
declare global {
  interface Window {
    __spa404Bound?: boolean;
  }
}

export {};
