export function getAdminKey(): string { 
  return localStorage.getItem("adminKey") || ""; 
}

export function setAdminKey(key: string) {
  localStorage.setItem("adminKey", key);
}

export function clearAdminKey() {
  localStorage.removeItem("adminKey");
}

export function setAdminSession(key: string) {
  localStorage.setItem("isAdmin", "true");
  localStorage.setItem("adminKey", key);
}

export function clearAdminSession() {
  localStorage.removeItem("isAdmin");
  localStorage.removeItem("adminKey");
}

export function isAdmin(): boolean {
  return typeof window !== "undefined" && localStorage.getItem("isAdmin") === "true";
}