import { initializeApp } from "firebase/app";
import { getAuth, signInWithPopup, GoogleAuthProvider, getIdTokenResult } from "firebase/auth";

// Check if admin env vars are available, fallback to main firebase config
const adminConfig = {
  apiKey: import.meta.env.VITE_FB_API_KEY || import.meta.env.VITE_FIREBASE_API_KEY,
  authDomain: import.meta.env.VITE_FB_AUTH_DOMAIN || `${import.meta.env.VITE_FIREBASE_PROJECT_ID}.firebaseapp.com`,
  projectId: import.meta.env.VITE_FB_PROJECT_ID || import.meta.env.VITE_FIREBASE_PROJECT_ID,
};

const app = initializeApp(adminConfig, "admin-app"); // Use different app name to avoid conflicts

export const auth = getAuth(app);

export async function signInAdminWithGoogle(): Promise<string> {
  const provider = new GoogleAuthProvider();
  const cred = await signInWithPopup(auth, provider);
  const token = await cred.user.getIdToken(true);
  const claims = (await getIdTokenResult(cred.user)).claims as any;
  if (!claims.admin) throw new Error("Not an admin account");
  return token;
}